/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.journal.inmemory;

import io.vlingo.common.Completes;
import io.vlingo.reactivestreams.Stream;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.store.journal.JournalReader;
import java.util.ArrayList;
import java.util.List;

public class InMemoryJournalReader<T extends Entry<?>>
implements JournalReader<T> {
    private int currentIndex;
    private final List<Entry<T>> journalView;
    private final String name;

    public InMemoryJournalReader(List<Entry<T>> journalView, String name) {
        this.journalView = journalView;
        this.name = name;
        this.currentIndex = 0;
    }

    @Override
    public void close() {
        this.journalView.clear();
    }

    @Override
    public Completes<String> name() {
        return Completes.withSuccess((Object)this.name);
    }

    @Override
    public Completes<T> readNext() {
        if (this.currentIndex < this.journalView.size()) {
            return Completes.withSuccess(this.journalView.get(this.currentIndex++));
        }
        return null;
    }

    @Override
    public Completes<T> readNext(String fromId) {
        this.seekTo(fromId);
        return this.readNext();
    }

    @Override
    public Completes<List<T>> readNext(int maximumEntries) {
        ArrayList<Entry<T>> entries = new ArrayList<Entry<T>>(maximumEntries);
        for (int count = 0; count < maximumEntries && this.currentIndex < this.journalView.size(); ++count) {
            entries.add(this.journalView.get(this.currentIndex++));
        }
        return Completes.withSuccess(entries);
    }

    @Override
    public Completes<List<T>> readNext(String fromId, int maximumEntries) {
        this.seekTo(fromId);
        return this.readNext(maximumEntries);
    }

    @Override
    public void rewind() {
        this.currentIndex = 0;
    }

    @Override
    public Completes<String> seekTo(String id) {
        String currentId;
        switch (id) {
            case "<": {
                this.rewind();
                currentId = this.readCurrentId();
                break;
            }
            case ">": {
                this.end();
                currentId = this.readCurrentId();
                break;
            }
            case "=": {
                currentId = this.readCurrentId();
                break;
            }
            default: {
                this.to(id);
                currentId = this.readCurrentId();
            }
        }
        return Completes.withSuccess((Object)currentId);
    }

    @Override
    public Completes<Long> size() {
        return Completes.withSuccess((Object)this.journalView.size());
    }

    @Override
    public Completes<Stream> streamAll() {
        return null;
    }

    private void end() {
        this.currentIndex = this.journalView.size() - 1;
    }

    private String readCurrentId() {
        if (this.currentIndex < this.journalView.size()) {
            String currentId = this.journalView.get(this.currentIndex).id();
            return currentId;
        }
        return "-1";
    }

    private void to(String id) {
        this.rewind();
        while (this.currentIndex < this.journalView.size()) {
            Entry<T> entry = this.journalView.get(this.currentIndex);
            if (entry.id().equals(id)) {
                return;
            }
            ++this.currentIndex;
        }
    }
}

