/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.journal.inmemory;

import io.vlingo.common.Completes;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.journal.EntityStream;
import io.vlingo.symbio.store.journal.StreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InMemoryStreamReader<T>
implements StreamReader<T> {
    private final List<BaseEntry<T>> journalView;
    private final Map<String, State<T>> snapshotsView;
    private final Map<String, Map<Integer, Integer>> streamIndexesView;
    private final String name;

    public InMemoryStreamReader(List<BaseEntry<T>> journalView, Map<String, Map<Integer, Integer>> streamIndexesView, Map<String, State<T>> snapshotsView, String name) {
        this.journalView = journalView;
        this.streamIndexesView = streamIndexesView;
        this.snapshotsView = snapshotsView;
        this.name = name;
    }

    @Override
    public Completes<EntityStream<T>> streamFor(String streamName) {
        return this.streamFor(streamName, 1);
    }

    @Override
    public Completes<EntityStream<T>> streamFor(String streamName, int fromStreamVersion) {
        int version = fromStreamVersion;
        State<T> snapshot = this.snapshotsView.get(streamName);
        if (snapshot != null) {
            if (snapshot.dataVersion > version) {
                version = snapshot.dataVersion;
            } else {
                snapshot = null;
            }
        }
        ArrayList entries = new ArrayList();
        Map<Integer, Integer> versionIndexes = this.streamIndexesView.get(streamName);
        if (versionIndexes != null) {
            Integer journalIndex = versionIndexes.get(version);
            while (journalIndex != null) {
                BaseEntry<T> entry = this.journalView.get(journalIndex);
                entries.add(entry);
                journalIndex = versionIndexes.get(++version);
            }
        }
        return Completes.withSuccess(new EntityStream(streamName, version - 1, entries, snapshot));
    }

    String name() {
        return this.name;
    }
}

