/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object;

import io.vlingo.common.Completes;
import io.vlingo.common.Outcome;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.store.EntryReader;
import io.vlingo.symbio.store.QueryExpression;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import java.util.Collection;

public interface ObjectStoreReader {
    public static final long NoId = -1L;

    public static boolean isNoId(long id) {
        return -1L == id;
    }

    public static boolean isId(long id) {
        return id > -1L;
    }

    public Completes<EntryReader<? extends Entry<?>>> entryReader(String var1);

    default public void queryAll(QueryExpression expression, QueryResultInterest interest) {
        this.queryAll(expression, interest, null);
    }

    public void queryAll(QueryExpression var1, QueryResultInterest var2, Object var3);

    default public void queryObject(QueryExpression expression, QueryResultInterest interest) {
        this.queryObject(expression, interest, null);
    }

    public void queryObject(QueryExpression var1, QueryResultInterest var2, Object var3);

    public static class QueryMultiResults
    extends QueryResult {
        public final Collection<?> stateObjects;

        public static QueryMultiResults of(Collection<?> stateObjects) {
            return new QueryMultiResults(stateObjects);
        }

        public static QueryMultiResults of(Collection<?> stateObjects, long updateId) {
            return new QueryMultiResults(stateObjects, updateId);
        }

        public QueryMultiResults(Collection<?> stateObjects) {
            this.stateObjects = stateObjects;
        }

        public QueryMultiResults(Collection<?> stateObjects, long updateId) {
            super(updateId);
            this.stateObjects = stateObjects;
        }

        public <T> Collection<T> stateObjects() {
            return this.stateObjects;
        }
    }

    public static class QuerySingleResult
    extends QueryResult {
        public final Object stateObject;

        public static QuerySingleResult of(Object stateObject) {
            return new QuerySingleResult(stateObject);
        }

        public static QuerySingleResult of(Object stateObject, long updateId) {
            return new QuerySingleResult(stateObject, updateId);
        }

        public QuerySingleResult(Object stateObject) {
            this.stateObject = stateObject;
        }

        public QuerySingleResult(Object stateObject, long updateId) {
            super(updateId);
            this.stateObject = stateObject;
        }

        public <T> T stateObject() {
            return (T)this.stateObject;
        }
    }

    public static abstract class QueryResult {
        public final long updateId;

        protected QueryResult() {
            this(-1L);
        }

        protected QueryResult(long updateId) {
            this.updateId = updateId;
        }

        public boolean isUpdatable() {
            return ObjectStoreReader.isId(this.updateId);
        }
    }

    public static interface QueryResultInterest {
        public void queryAllResultedIn(Outcome<StorageException, Result> var1, QueryMultiResults var2, Object var3);

        public void queryObjectResultedIn(Outcome<StorageException, Result> var1, QuerySingleResult var2, Object var3);
    }
}

