/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class StateObject
implements Serializable {
    protected static final long Unidentified = -1L;
    private static final long InitialVersion = 0L;
    private static final long serialVersionUID = 1L;
    private long persistenceId = -1L;
    private long version = 0L;

    public static StateObject from(Object stateObject) {
        return (StateObject)stateObject;
    }

    public static long unidentified() {
        return -1L;
    }

    public long persistenceId() {
        return this.persistenceId;
    }

    public boolean isIdentified() {
        return this.persistenceId != -1L;
    }

    public long version() {
        return this.version;
    }

    public void incrementVersion() {
        ++this.version;
    }

    public List<Object> queryList() {
        return Collections.emptyList();
    }

    public Map<String, Object> queryMap() {
        return Collections.emptyMap();
    }

    public void __internal__setPersistenceId(long persistenceId) {
        this.persistenceId = persistenceId;
    }

    protected StateObject(long persistenceId, long version) {
        this();
        this.persistenceId = persistenceId;
        this.version = version;
    }

    protected StateObject(long persistenceId) {
        this();
        this.persistenceId = persistenceId;
    }

    protected StateObject() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.persistenceId ^ this.persistenceId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StateObject other = (StateObject)obj;
        return this.persistenceId == other.persistenceId;
    }
}

