/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object;

import io.vlingo.symbio.Source;
import io.vlingo.symbio.store.object.StateObject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class StateSources<T extends StateObject, E> {
    private T stateObject;
    private List<Source<E>> sources;

    public StateSources(T stateObject) {
        this(stateObject, Source.none());
    }

    public StateSources(T stateObject, List<Source<E>> sources) {
        if (stateObject == null) {
            throw new IllegalArgumentException("stateObject is required");
        }
        this.stateObject = stateObject;
        if (sources == null) {
            throw new IllegalArgumentException("sources is required");
        }
        this.sources = sources;
    }

    public static <T extends StateObject, E> StateSources<T, E> of(T stateObject) {
        return new StateSources<T, E>(stateObject, Source.none());
    }

    public static <T extends StateObject, E> StateSources<T, E> of(T stateObject, Source<E> source) {
        return new StateSources<T, E>(stateObject, Collections.singletonList(source));
    }

    public static <T extends StateObject, E> StateSources<T, E> of(T stateObject, List<Source<E>> sources) {
        return new StateSources<T, E>(stateObject, sources);
    }

    public T stateObject() {
        return this.stateObject;
    }

    public List<Source<E>> sources() {
        return Collections.unmodifiableList(this.sources);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateSources that = (StateSources)o;
        return ((StateObject)this.stateObject).equals(that.stateObject) && this.sources.equals(that.sources);
    }

    public int hashCode() {
        return Objects.hash(this.stateObject, this.sources);
    }

    public String toString() {
        return "StateSources{stateObject=" + this.stateObject + ", sources=" + this.sources + '}';
    }
}

