/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.inmemory;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Definition;
import io.vlingo.common.Completes;
import io.vlingo.common.Failure;
import io.vlingo.common.Outcome;
import io.vlingo.common.Success;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.EntryAdapterProvider;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.Source;
import io.vlingo.symbio.State;
import io.vlingo.symbio.StateAdapterProvider;
import io.vlingo.symbio.store.EntryReader;
import io.vlingo.symbio.store.QueryExpression;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.Dispatcher;
import io.vlingo.symbio.store.dispatch.DispatcherControl;
import io.vlingo.symbio.store.dispatch.control.DispatcherControlActor;
import io.vlingo.symbio.store.object.ObjectStore;
import io.vlingo.symbio.store.object.ObjectStoreDelegate;
import io.vlingo.symbio.store.object.ObjectStoreEntryReader;
import io.vlingo.symbio.store.object.ObjectStoreReader;
import io.vlingo.symbio.store.object.ObjectStoreWriter;
import io.vlingo.symbio.store.object.StateObject;
import io.vlingo.symbio.store.object.StateSources;
import io.vlingo.symbio.store.object.inmemory.InMemoryObjectStoreDelegate;
import io.vlingo.symbio.store.object.inmemory.InMemoryObjectStoreEntryReaderActor;
import io.vlingo.symbio.store.state.StateStoreEntryReader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InMemoryObjectStoreActor
extends Actor
implements ObjectStore {
    private final EntryAdapterProvider entryAdapterProvider = EntryAdapterProvider.instance(this.stage().world());
    private final List<Dispatcher<Dispatchable<BaseEntry<?>, State<?>>>> dispatchers;
    private final DispatcherControl dispatcherControl;
    private final Map<String, StateStoreEntryReader<?>> entryReaders;
    private final ObjectStoreDelegate<BaseEntry<?>, State<?>> storeDelegate;

    public InMemoryObjectStoreActor(Dispatcher<Dispatchable<BaseEntry<?>, State<?>>> dispatcher) {
        this(Arrays.asList(dispatcher), 1000L, 1000L);
    }

    public InMemoryObjectStoreActor(List<Dispatcher<Dispatchable<BaseEntry<?>, State<?>>>> dispatchers, long checkConfirmationExpirationInterval, long confirmationExpiration) {
        this.dispatchers = dispatchers;
        this.entryReaders = new HashMap();
        this.storeDelegate = new InMemoryObjectStoreDelegate(StateAdapterProvider.instance(this.stage().world()));
        this.dispatcherControl = (DispatcherControl)this.stage().actorFor(DispatcherControl.class, Definition.has(DispatcherControlActor.class, new DispatcherControl.DispatcherControlInstantiator(dispatchers, this.storeDelegate, checkConfirmationExpirationInterval, confirmationExpiration)));
    }

    @Override
    public void close() {
        this.storeDelegate.close();
    }

    @Override
    public Completes<EntryReader<? extends Entry<?>>> entryReader(String name) {
        EntryReader reader = this.entryReaders.get(name);
        if (reader == null) {
            Definition definition = Definition.has(InMemoryObjectStoreEntryReaderActor.class, (ActorInstantiator)new ObjectStoreEntryReaderInstantiator(this.readOnlyJournal(), name));
            reader = (EntryReader)this.childActorFor(ObjectStoreEntryReader.class, definition);
        }
        return this.completes().with((Object)reader);
    }

    @Override
    public <T extends StateObject, E> void persist(StateSources<T, E> stateSources, Metadata metadata, long updateId, ObjectStoreWriter.PersistResultInterest interest, Object object) {
        try {
            T stateObject = stateSources.stateObject();
            List<Source<E>> sources = stateSources.sources();
            State<?> raw = this.storeDelegate.persist(stateObject, updateId, metadata);
            int entryVersion = (int)((StateObject)stateSources.stateObject()).version();
            List<BaseEntry<?>> entries = this.entryAdapterProvider.asEntries(sources, entryVersion, metadata);
            Dispatchable<BaseEntry<?>, State<?>> dispatchable = InMemoryObjectStoreActor.buildDispatchable(raw, entries);
            this.storeDelegate.persistEntries(entries);
            this.storeDelegate.persistDispatchable(dispatchable);
            this.dispatch(dispatchable);
            interest.persistResultedIn((Outcome<StorageException, Result>)Success.of((Object)((Object)Result.Success)), stateObject, 1, 1, object);
        }
        catch (StorageException e) {
            this.logger().error("Failed to persist all objects", (Throwable)e);
            interest.persistResultedIn((Outcome<StorageException, Result>)Failure.of((Throwable)e), null, 0, 0, object);
        }
    }

    @Override
    public <T extends StateObject, E> void persistAll(Collection<StateSources<T, E>> allStateSources, Metadata metadata, long updateId, ObjectStoreWriter.PersistResultInterest interest, Object object) {
        ArrayList<T> allPersistentObjects = new ArrayList<T>();
        try {
            for (StateSources<T, E> stateSources : allStateSources) {
                T stateObject = stateSources.stateObject();
                State<?> state = this.storeDelegate.persist(stateObject, updateId, metadata);
                allPersistentObjects.add(stateObject);
                int entryVersion = (int)((StateObject)stateSources.stateObject()).version();
                List<BaseEntry<?>> entries = this.entryAdapterProvider.asEntries(stateSources.sources(), entryVersion, metadata);
                this.storeDelegate.persistEntries(entries);
                Dispatchable<BaseEntry<?>, State<?>> dispatchable = InMemoryObjectStoreActor.buildDispatchable(state, entries);
                this.storeDelegate.persistDispatchable(dispatchable);
                this.dispatch(InMemoryObjectStoreActor.buildDispatchable(state, entries));
            }
            interest.persistResultedIn((Outcome<StorageException, Result>)Success.of((Object)((Object)Result.Success)), allPersistentObjects, allPersistentObjects.size(), allPersistentObjects.size(), object);
        }
        catch (StorageException e) {
            this.logger().error("Failed to persist all objects", (Throwable)e);
            interest.persistResultedIn((Outcome<StorageException, Result>)Failure.of((Throwable)e), null, 0, 0, object);
        }
    }

    @Override
    public void queryAll(QueryExpression expression, ObjectStoreReader.QueryResultInterest interest, Object object) {
        ObjectStoreReader.QueryMultiResults queryMultiResults = this.storeDelegate.queryAll(expression);
        interest.queryAllResultedIn((Outcome<StorageException, Result>)Success.of((Object)((Object)Result.Success)), queryMultiResults, object);
    }

    @Override
    public void queryObject(QueryExpression expression, ObjectStoreReader.QueryResultInterest interest, Object object) {
        ObjectStoreReader.QuerySingleResult result = this.storeDelegate.queryObject(expression);
        if (result.stateObject != null) {
            interest.queryObjectResultedIn((Outcome<StorageException, Result>)Success.of((Object)((Object)Result.Success)), result, object);
        } else {
            interest.queryObjectResultedIn((Outcome<StorageException, Result>)Failure.of((Throwable)new StorageException(Result.NotFound, "No object identified by expression: " + expression)), ObjectStoreReader.QuerySingleResult.of(null), object);
        }
    }

    public void stop() {
        this.dispatcherControl.stop();
        super.stop();
    }

    private void dispatch(Dispatchable<BaseEntry<?>, State<?>> dispatchable) {
        this.dispatchers.forEach(d -> d.dispatch(dispatchable));
    }

    private static Dispatchable<BaseEntry<?>, State<?>> buildDispatchable(State<?> state, List<BaseEntry<?>> entries) {
        String id = InMemoryObjectStoreActor.getDispatchId(state, entries);
        return new Dispatchable(id, LocalDateTime.now(), state, entries);
    }

    private static String getDispatchId(State<?> raw, List<BaseEntry<?>> entries) {
        return raw.id + ":" + entries.stream().map(Entry::id).collect(Collectors.joining(":"));
    }

    private List<BaseEntry<?>> readOnlyJournal() {
        return ((InMemoryObjectStoreDelegate)this.storeDelegate).readOnlyJournal();
    }

    private static class ObjectStoreEntryReaderInstantiator
    implements ActorInstantiator<InMemoryObjectStoreEntryReaderActor> {
        private static final long serialVersionUID = -2022300658559205459L;
        final String name;
        final List<BaseEntry<?>> readOnlyJournal;

        ObjectStoreEntryReaderInstantiator(List<BaseEntry<?>> readOnlyJournal, String name) {
            this.readOnlyJournal = readOnlyJournal;
            this.name = name;
        }

        public InMemoryObjectStoreEntryReaderActor instantiate() {
            return new InMemoryObjectStoreEntryReaderActor((List)this.readOnlyJournal(), this.name);
        }

        public Class<InMemoryObjectStoreEntryReaderActor> type() {
            return InMemoryObjectStoreEntryReaderActor.class;
        }

        <E, ET extends Entry<E>> ET readOnlyJournal() {
            return (ET)((Entry)((Object)this.readOnlyJournal));
        }
    }
}

