/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.inmemory;

import io.vlingo.common.identity.IdentityGenerator;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.State;
import io.vlingo.symbio.StateAdapterProvider;
import io.vlingo.symbio.store.QueryExpression;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.DispatcherControl;
import io.vlingo.symbio.store.object.ObjectStoreDelegate;
import io.vlingo.symbio.store.object.ObjectStoreReader;
import io.vlingo.symbio.store.object.StateObject;
import io.vlingo.symbio.store.object.StateObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public class InMemoryObjectStoreDelegate
implements ObjectStoreDelegate<BaseEntry<?>, State<?>>,
DispatcherControl.DispatcherControlDelegate<BaseEntry<?>, State<?>> {
    private long nextId;
    private final Map<Class<?>, Map<Long, State<?>>> stores;
    private final List<BaseEntry<?>> entries;
    private final List<Dispatchable<BaseEntry<?>, State<?>>> dispatchables;
    private final StateAdapterProvider stateAdapterProvider;
    private final IdentityGenerator identityGenerator;

    public InMemoryObjectStoreDelegate(StateAdapterProvider stateAdapterProvider) {
        this.stateAdapterProvider = stateAdapterProvider;
        this.stores = new HashMap();
        this.entries = new ArrayList();
        this.dispatchables = new CopyOnWriteArrayList();
        this.identityGenerator = new IdentityGenerator.RandomIdentityGenerator();
        this.nextId = 1L;
    }

    private static String idParameterAsString(Object id) {
        if (id == null) {
            return null;
        }
        if (id instanceof String) {
            return (String)id;
        }
        if (id instanceof Long) {
            return String.valueOf((Long)id);
        }
        if (id instanceof Integer) {
            return String.valueOf((Integer)id);
        }
        return String.valueOf(id);
    }

    @Override
    public void registerMapper(StateObjectMapper mapper) {
    }

    @Override
    public void close() {
        this.stores.clear();
        this.entries.clear();
        this.dispatchables.clear();
    }

    @Override
    public void stop() {
        this.close();
    }

    @Override
    public ObjectStoreDelegate copy() {
        return new InMemoryObjectStoreDelegate(this.stateAdapterProvider);
    }

    @Override
    public void beginTransaction() {
    }

    @Override
    public void completeTransaction() {
    }

    @Override
    public void failTransaction() {
    }

    @Override
    public <T extends StateObject> Collection<State<?>> persistAll(Collection<T> stateObjects, long updateId, Metadata metadata) {
        ArrayList states = new ArrayList(stateObjects.size());
        for (StateObject stateObject : stateObjects) {
            State<?> raw = this.persist(stateObject, metadata);
            states.add(raw);
        }
        return states;
    }

    private <T extends StateObject> State<?> persist(T stateObject, Metadata metadata) {
        long l;
        Object raw = this.stateAdapterProvider.asRaw(String.valueOf(stateObject.persistenceId()), stateObject, 1, metadata);
        Map store = this.stores.computeIfAbsent(stateObject.getClass(), type -> new HashMap());
        if (stateObject.persistenceId() == -1L) {
            long l2 = this.nextId;
            l = l2;
            this.nextId = l2 + 1L;
        } else {
            l = stateObject.persistenceId();
        }
        long persistenceId = l;
        store.put(persistenceId, raw);
        stateObject.__internal__setPersistenceId(persistenceId);
        return raw;
    }

    @Override
    public <T extends StateObject> State<?> persist(T stateObject, long updateId, Metadata metadata) {
        return this.persist(stateObject, metadata);
    }

    @Override
    public void persistEntries(Collection<BaseEntry<?>> entries) {
        entries.forEach(baseEntry -> baseEntry.__internal__setId(this.identityGenerator.generate().toString()));
        this.entries.addAll(entries);
    }

    @Override
    public void persistDispatchable(Dispatchable<BaseEntry<?>, State<?>> dispatchable) {
        this.dispatchables.add(dispatchable);
    }

    @Override
    public ObjectStoreReader.QueryMultiResults queryAll(QueryExpression expression) {
        HashSet all = new HashSet();
        Map store = this.stores.computeIfAbsent(expression.type, type -> new HashMap());
        for (State entry : store.values()) {
            Object stateObject = this.stateAdapterProvider.fromRaw(entry);
            all.add(stateObject);
        }
        return new ObjectStoreReader.QueryMultiResults(all);
    }

    @Override
    public ObjectStoreReader.QuerySingleResult queryObject(QueryExpression expression) {
        String id;
        if (expression.isListQueryExpression()) {
            id = InMemoryObjectStoreDelegate.idParameterAsString(expression.asListQueryExpression().parameters.get(0));
        } else if (expression.isMapQueryExpression()) {
            id = InMemoryObjectStoreDelegate.idParameterAsString(expression.asMapQueryExpression().parameters.get("id"));
        } else {
            throw new StorageException(Result.Error, "Unknown query type: " + expression);
        }
        Map store = this.stores.computeIfAbsent(expression.type, type -> new HashMap());
        State found = id == null || id.equals("-1") ? null : (State)store.get(Long.parseLong(id));
        Object result = Optional.ofNullable(found).map(this.stateAdapterProvider::fromRaw).orElse(null);
        return new ObjectStoreReader.QuerySingleResult(result);
    }

    @Override
    public Collection<Dispatchable<BaseEntry<?>, State<?>>> allUnconfirmedDispatchableStates() {
        return new ArrayList(this.dispatchables);
    }

    @Override
    public void confirmDispatched(String dispatchId) {
        this.dispatchables.stream().filter(d -> d.id().equals(dispatchId)).findFirst().ifPresent(this.dispatchables::remove);
    }

    List<BaseEntry<?>> readOnlyJournal() {
        return this.entries;
    }
}

