/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StateTypeStateStoreMap {
    private static final Map<String, String> stateStoreNames = new ConcurrentHashMap<String, String>();

    public static Collection<String> allStoreNames() {
        return Collections.unmodifiableCollection(stateStoreNames.values());
    }

    public static void stateTypeToStoreName(Class<?> type, String storeName) {
        stateStoreNames.putIfAbsent(type.getName(), storeName);
    }

    public static String storeNameFrom(Class<?> type) {
        return StateTypeStateStoreMap.storeNameFrom(type.getName());
    }

    public static String storeNameFrom(String type) {
        return stateStoreNames.get(type);
    }

    public static void reset() {
        stateStoreNames.clear();
    }
}

