/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state.inmemory;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Definition;
import io.vlingo.common.Completes;
import io.vlingo.common.Failure;
import io.vlingo.common.Outcome;
import io.vlingo.common.Success;
import io.vlingo.reactivestreams.Stream;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.EntryAdapterProvider;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.Source;
import io.vlingo.symbio.State;
import io.vlingo.symbio.StateAdapterProvider;
import io.vlingo.symbio.store.QueryExpression;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.Dispatcher;
import io.vlingo.symbio.store.dispatch.DispatcherControl;
import io.vlingo.symbio.store.dispatch.control.DispatcherControlActor;
import io.vlingo.symbio.store.dispatch.inmemory.InMemoryDispatcherControlDelegate;
import io.vlingo.symbio.store.state.StateStore;
import io.vlingo.symbio.store.state.StateStoreEntryReader;
import io.vlingo.symbio.store.state.StateStream;
import io.vlingo.symbio.store.state.StateTypeStateStoreMap;
import io.vlingo.symbio.store.state.inmemory.InMemoryStateStoreEntryReaderActor;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class InMemoryStateStoreActor<RS extends State<?>>
extends Actor
implements StateStore {
    private final List<Dispatchable<Entry<?>, RS>> dispatchables;
    private final List<Dispatcher<Dispatchable<Entry<?>, RS>>> dispatchers;
    private final DispatcherControl dispatcherControl;
    private final List<Entry<?>> entries;
    private final Map<String, StateStoreEntryReader<?>> entryReaders;
    private final EntryAdapterProvider entryAdapterProvider;
    private final StateAdapterProvider stateAdapterProvider;
    private final Map<String, Map<String, RS>> store;

    public InMemoryStateStoreActor(List<Dispatcher<Dispatchable<Entry<?>, RS>>> dispatchers, long checkConfirmationExpirationInterval, long confirmationExpiration) {
        if (dispatchers == null) {
            throw new IllegalArgumentException("Dispatcher must not be null.");
        }
        this.dispatchers = dispatchers;
        this.entryAdapterProvider = EntryAdapterProvider.instance(this.stage().world());
        this.stateAdapterProvider = StateAdapterProvider.instance(this.stage().world());
        this.entries = new CopyOnWriteArrayList();
        this.entryReaders = new HashMap();
        this.store = new HashMap<String, Map<String, RS>>();
        this.dispatchables = new CopyOnWriteArrayList();
        InMemoryDispatcherControlDelegate dispatcherControlDelegate = new InMemoryDispatcherControlDelegate(this.dispatchables);
        this.dispatcherControl = (DispatcherControl)this.stage().actorFor(DispatcherControl.class, Definition.has(DispatcherControlActor.class, new DispatcherControl.DispatcherControlInstantiator(dispatchers, dispatcherControlDelegate, checkConfirmationExpirationInterval, confirmationExpiration)));
    }

    public InMemoryStateStoreActor(List<Dispatcher<Dispatchable<Entry<?>, RS>>> dispatchers) {
        this(dispatchers, 1000L, 1000L);
    }

    public void stop() {
        if (this.dispatcherControl != null) {
            this.dispatcherControl.stop();
        }
        super.stop();
    }

    @Override
    public <ET extends Entry<?>> Completes<StateStoreEntryReader<ET>> entryReader(String name) {
        StateStoreEntryReader reader = this.entryReaders.get(name);
        if (reader == null) {
            reader = (StateStoreEntryReader)this.childActorFor(StateStoreEntryReader.class, Definition.has(InMemoryStateStoreEntryReaderActor.class, (ActorInstantiator)new StateStoreEntryReaderInstantiator(this.entries, name)));
            this.entryReaders.put(name, reader);
        }
        return this.completes().with(reader);
    }

    @Override
    public void read(String id, Class<?> type, StateStore.ReadResultInterest interest, Object object) {
        this.readFor(id, type, interest, object);
    }

    @Override
    public Completes<Stream> streamAllOf(Class<?> stateType) {
        String storeName = StateTypeStateStoreMap.storeNameFrom(stateType);
        return this.completes().with(new StateStream<RS>(this.stage(), this.store.get(storeName), this.stateAdapterProvider));
    }

    @Override
    public Completes<Stream> streamSomeUsing(QueryExpression query) {
        return null;
    }

    @Override
    public <S, C> void write(String id, S state, int stateVersion, List<Source<C>> sources, Metadata metadata, StateStore.WriteResultInterest interest, Object object) {
        this.writeWith(id, state, stateVersion, sources, metadata, interest, object);
    }

    private void readFor(String id, Class<?> type, StateStore.ReadResultInterest interest, Object object) {
        if (interest != null) {
            if (id == null || type == null) {
                interest.readResultedIn((Outcome<StorageException, Result>)Failure.of((Throwable)new StorageException(Result.Error, id == null ? "The id is null." : "The type is null.")), id, null, -1, null, object);
                return;
            }
            String storeName = StateTypeStateStoreMap.storeNameFrom(type);
            if (storeName == null) {
                interest.readResultedIn((Outcome<StorageException, Result>)Failure.of((Throwable)new StorageException(Result.NoTypeStore, "No type store for: " + type.getSimpleName())), id, null, -1, null, object);
                return;
            }
            Map<String, RS> typeStore = this.store.get(storeName);
            if (typeStore == null) {
                interest.readResultedIn((Outcome<StorageException, Result>)Failure.of((Throwable)new StorageException(Result.NotFound, "Store not found: " + storeName)), id, null, -1, null, object);
                return;
            }
            State raw = (State)typeStore.get(id);
            if (raw != null) {
                Object state = this.stateAdapterProvider.fromRaw(raw);
                interest.readResultedIn((Outcome<StorageException, Result>)Success.of((Object)((Object)Result.Success)), id, state, raw.dataVersion, raw.metadata, object);
            } else {
                for (String storeId : typeStore.keySet()) {
                    this.logger().debug("UNFOUND STATES\n=====================");
                    this.logger().debug("STORE ID: '" + storeId + "' STATE: " + typeStore.get(storeId));
                }
                interest.readResultedIn((Outcome<StorageException, Result>)Failure.of((Throwable)new StorageException(Result.NotFound, "Not found.")), id, null, -1, null, object);
            }
        } else {
            this.logger().warn(this.getClass().getSimpleName() + " readText() missing ReadResultInterest for: " + (id == null ? "unknown id" : id));
        }
    }

    private <S, C> void writeWith(String id, S state, int stateVersion, List<Source<C>> sources, Metadata metadata, StateStore.WriteResultInterest interest, Object object) {
        if (interest != null) {
            if (state == null) {
                interest.writeResultedIn((Outcome<StorageException, Result>)Failure.of((Throwable)new StorageException(Result.Error, "The state is null.")), id, state, stateVersion, sources, object);
            } else {
                try {
                    Object raw;
                    State persistedState;
                    Map<String, RS> existingTypeStore;
                    String storeName = StateTypeStateStoreMap.storeNameFrom(state.getClass());
                    if (storeName == null) {
                        interest.writeResultedIn((Outcome<StorageException, Result>)Failure.of((Throwable)new StorageException(Result.NoTypeStore, "No type store for: " + state.getClass())), id, state, stateVersion, sources, object);
                        return;
                    }
                    Map<String, RS> typeStore = this.store.get(storeName);
                    if (typeStore == null && (existingTypeStore = this.store.putIfAbsent(storeName, typeStore = new HashMap<String, RS>())) != null) {
                        typeStore = existingTypeStore;
                    }
                    if ((persistedState = (State)typeStore.putIfAbsent(((State)raw).id, raw = metadata == null ? this.stateAdapterProvider.asRaw(id, state, stateVersion) : this.stateAdapterProvider.asRaw(id, state, stateVersion, metadata))) != null && persistedState.dataVersion >= ((State)raw).dataVersion) {
                        interest.writeResultedIn((Outcome<StorageException, Result>)Failure.of((Throwable)new StorageException(Result.ConcurrencyViolation, "Version conflict.")), id, state, stateVersion, sources, object);
                        return;
                    }
                    typeStore.put(id, raw);
                    List<Entry<?>> entries = this.appendEntries(sources, stateVersion, metadata);
                    this.dispatch(id, storeName, raw, entries);
                    interest.writeResultedIn((Outcome<StorageException, Result>)Success.of((Object)((Object)Result.Success)), id, state, stateVersion, sources, object);
                }
                catch (Exception e) {
                    this.logger().error(this.getClass().getSimpleName() + " writeText() error because: " + e.getMessage(), (Throwable)e);
                    interest.writeResultedIn((Outcome<StorageException, Result>)Failure.of((Throwable)new StorageException(Result.Error, e.getMessage(), e)), id, state, stateVersion, sources, object);
                }
            }
        } else {
            this.logger().warn(this.getClass().getSimpleName() + " writeText() missing WriteResultInterest for: " + (state == null ? "unknown id" : id));
        }
    }

    private <C> List<Entry<?>> appendEntries(List<Source<C>> sources, int stateVersion, Metadata metadata) {
        List<Entry<?>> adapted = this.entryAdapterProvider.asEntries(sources, stateVersion, metadata);
        for (Entry entry : adapted) {
            ((BaseEntry)entry).__internal__setId(String.valueOf(this.entries.size()));
            this.entries.add(entry);
        }
        return adapted;
    }

    private void dispatch(String id, String storeName, RS raw, List<Entry<?>> entries) {
        String dispatchId = storeName + ":" + id;
        Dispatchable dispatchable = new Dispatchable(dispatchId, LocalDateTime.now(), raw, entries);
        this.dispatchables.add(dispatchable);
        this.dispatchers.forEach(p -> p.dispatch(dispatchable));
    }

    private static class StateStoreEntryReaderInstantiator
    implements ActorInstantiator<InMemoryStateStoreEntryReaderActor> {
        private static final long serialVersionUID = 8463366612347915854L;
        final String name;
        final List<Entry<?>> entries;

        StateStoreEntryReaderInstantiator(List<Entry<?>> entries, String name) {
            this.entries = entries;
            this.name = name;
        }

        public InMemoryStateStoreEntryReaderActor instantiate() {
            return new InMemoryStateStoreEntryReaderActor(this.entries, this.name);
        }

        public Class<InMemoryStateStoreEntryReaderActor> type() {
            return InMemoryStateStoreEntryReaderActor.class;
        }
    }
}

