/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state.inmemory;

import io.vlingo.actors.Actor;
import io.vlingo.common.Completes;
import io.vlingo.reactivestreams.Stream;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.EntryAdapterProvider;
import io.vlingo.symbio.store.EntryReader;
import io.vlingo.symbio.store.EntryReaderStream;
import io.vlingo.symbio.store.journal.JournalReader;
import io.vlingo.symbio.store.state.StateStoreEntryReader;
import java.util.ArrayList;
import java.util.List;

public class InMemoryStateStoreEntryReaderActor<T extends Entry<?>>
extends Actor
implements StateStoreEntryReader<T> {
    private int currentIndex;
    private final EntryAdapterProvider entryAdapterProvider;
    private final List<Entry<T>> entriesView;
    private final String name;

    public InMemoryStateStoreEntryReaderActor(List<Entry<T>> entriesView, String name) {
        this.entriesView = entriesView;
        this.name = name;
        this.entryAdapterProvider = EntryAdapterProvider.instance(this.stage().world());
        this.currentIndex = 0;
    }

    @Override
    public void close() {
        this.currentIndex = -1;
        this.entriesView.clear();
    }

    @Override
    public Completes<String> name() {
        return this.completes().with((Object)this.name);
    }

    @Override
    public Completes<T> readNext() {
        if (this.currentIndex < this.entriesView.size()) {
            return this.completes().with(this.entriesView.get(this.currentIndex++));
        }
        return this.completes().with(null);
    }

    @Override
    public Completes<T> readNext(String fromId) {
        this.seekTo(fromId);
        return this.readNext();
    }

    @Override
    public Completes<List<T>> readNext(int maximumEntries) {
        ArrayList<Entry<T>> entries = new ArrayList<Entry<T>>(maximumEntries);
        for (int count = 0; count < maximumEntries && this.currentIndex < this.entriesView.size(); ++count) {
            entries.add(this.entriesView.get(this.currentIndex++));
        }
        return this.completes().with(entries);
    }

    @Override
    public Completes<List<T>> readNext(String fromId, int maximumEntries) {
        this.seekTo(fromId);
        return this.readNext(maximumEntries);
    }

    @Override
    public void rewind() {
        this.currentIndex = 0;
    }

    @Override
    public Completes<String> seekTo(String id) {
        String currentId;
        switch (id) {
            case "<": {
                this.rewind();
                currentId = this.readCurrentId();
                break;
            }
            case ">": {
                this.end();
                currentId = this.readCurrentId();
                break;
            }
            case "=": {
                currentId = this.readCurrentId();
                break;
            }
            default: {
                this.to(id);
                currentId = this.readCurrentId();
            }
        }
        return this.completes().with((Object)currentId);
    }

    @Override
    public Completes<Long> size() {
        return this.completes().with((Object)this.entriesView.size());
    }

    @Override
    public Completes<Stream> streamAll() {
        return this.completes().with(new EntryReaderStream(this.stage(), (EntryReader)this.selfAs(JournalReader.class), this.entryAdapterProvider));
    }

    private void end() {
        this.currentIndex = this.entriesView.size();
    }

    private String readCurrentId() {
        if (this.currentIndex < this.entriesView.size()) {
            String currentId = this.entriesView.get(this.currentIndex).id();
            return currentId;
        }
        return "-1";
    }

    private void to(String id) {
        this.rewind();
        while (this.currentIndex < this.entriesView.size()) {
            Entry<T> entry = this.entriesView.get(this.currentIndex);
            if (entry.id().equals(id)) {
                return;
            }
            ++this.currentIndex;
        }
    }
}

