/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.channel;

import io.vlingo.actors.Logger;
import io.vlingo.wire.channel.ChannelReaderConsumer;
import io.vlingo.wire.message.RawMessage;
import io.vlingo.wire.message.RawMessageBuilder;

public interface ChannelMessageDispatcher {
    public ChannelReaderConsumer consumer();

    public Logger logger();

    public String name();

    default public void dispatchMessagesFor(RawMessageBuilder builder) {
        if (!builder.hasContent()) {
            return;
        }
        builder.prepareContent().sync();
        while (builder.isCurrentMessageComplete()) {
            try {
                RawMessage message = builder.currentRawMessage();
                this.consumer().consume(message);
            }
            catch (Exception e) {
                this.logger().error("Cannot dispatch message for: '" + this.name() + "'", (Throwable)e);
            }
            builder.prepareForNextMessage();
            if (!builder.hasContent()) continue;
            builder.sync();
        }
    }
}

