/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.channel;

import io.vlingo.actors.Logger;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collections;
import java.util.Iterator;

public class RefreshableSelector {
    private static Iterator<SelectionKey> EmptyIterator = Collections.emptyListIterator();
    private static Logger logger;
    private static long threshold;
    private static ThresholdType thresholdType;
    private final String name;
    private long refreshedCount;
    private Selector selector;
    private long trackingValue;

    public static void withCountedThreshold(int maximumSelects, Logger logger) {
        RefreshableSelector.initializeWith(ThresholdType.Counted, maximumSelects, logger);
    }

    public static void withNoThreshold(Logger logger) {
        RefreshableSelector.initializeWith(ThresholdType.None, 0L, logger);
    }

    public static void withTimedThreshold(long milliseconds, Logger logger) {
        RefreshableSelector.initializeWith(ThresholdType.Timed, milliseconds, logger);
    }

    public static RefreshableSelector open(String name) {
        return new RefreshableSelector(name);
    }

    public void close() throws IOException {
        this.selector.close();
    }

    public SelectionKey keyFor(SelectableChannel channel) throws IOException {
        return channel.keyFor(this.selector);
    }

    public SelectionKey registerWith(SelectableChannel channel, int options) throws ClosedChannelException {
        return this.registerWith(channel, options, null);
    }

    public SelectionKey registerWith(SelectableChannel channel, int options, Object attachment) throws ClosedChannelException {
        return channel.register(this.selector, options, attachment);
    }

    public Iterator<SelectionKey> select(long timeout) throws IOException {
        switch (thresholdType) {
            case Counted: {
                if (this.trackingValue++ < threshold) break;
                this.refresh();
                this.trackingValue = 0L;
                break;
            }
            case None: {
                break;
            }
            case Timed: {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.trackingValue < threshold) break;
                this.refresh();
                this.trackingValue = currentTime;
            }
        }
        if (this.selector.select(timeout) > 0) {
            return this.selector.selectedKeys().iterator();
        }
        return EmptyIterator;
    }

    public Iterator<SelectionKey> selectNow() throws IOException {
        return this.select(1L);
    }

    public long refreshedCount() {
        return this.refreshedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetForTest() {
        Class<RefreshableSelector> clazz = RefreshableSelector.class;
        synchronized (RefreshableSelector.class) {
            thresholdType = null;
            threshold = 0L;
            logger = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeWith(ThresholdType thresholdType, long threshold, Logger logger) {
        Class<RefreshableSelector> clazz = RefreshableSelector.class;
        synchronized (RefreshableSelector.class) {
            if (RefreshableSelector.thresholdType == null) {
                RefreshableSelector.thresholdType = thresholdType;
                RefreshableSelector.threshold = threshold;
                RefreshableSelector.logger = logger;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    private RefreshableSelector(String name) {
        this.name = name;
        this.refreshedCount = 0L;
        this.selector = this.open();
        this.trackingValue = this.determineTrackingValue();
    }

    private long determineTrackingValue() {
        switch (thresholdType) {
            case Counted: {
                return 0L;
            }
            case None: {
                return 0L;
            }
            case Timed: {
                return System.currentTimeMillis();
            }
        }
        return 0L;
    }

    private Selector open() {
        try {
            return Selector.open();
        }
        catch (Exception e) {
            String message = "Failed to open selector for '" + this.name + "' because: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new IllegalArgumentException(message);
        }
    }

    private void refresh() {
        Selector refreshedSelector = this.open();
        int total = 0;
        for (SelectionKey key : this.selector.keys()) {
            SelectableChannel channel = key.channel();
            Object attachment = key.attachment();
            try {
                if (!key.isValid() || channel.keyFor(refreshedSelector) != null) continue;
                int options = key.interestOps();
                key.cancel();
                channel.register(refreshedSelector, options, attachment);
                ++total;
            }
            catch (Throwable t) {
                this.warnAbout(this.getClass().getSimpleName() + ": Did not register channel " + channel.toString() + " to refreshed selector '" + this.name + "' because of: " + t.getMessage(), t);
            }
        }
        this.swap(refreshedSelector);
        ++this.refreshedCount;
        this.tellAbout("Refreshed " + total + " channels to the refreshed selector '" + this.name + "'");
    }

    private void swap(Selector refreshedSelector) {
        Selector selectorToReplace = this.selector;
        this.selector = refreshedSelector;
        try {
            selectorToReplace.close();
        }
        catch (Exception e) {
            this.warnAbout(this.getClass().getSimpleName() + ": Did not close previous selector of '" + this.name + "' because of: " + e.getMessage(), e);
        }
    }

    private void tellAbout(String message) {
        if (logger.isEnabled()) {
            logger.info(message);
        }
    }

    private void warnAbout(String message, Throwable t) {
        if (logger.isEnabled()) {
            logger.warn(message, t);
        }
    }

    private static enum ThresholdType {
        Counted,
        None,
        Timed;

    }
}

