/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.channel;

import io.vlingo.actors.Logger;
import io.vlingo.wire.message.RawMessage;
import io.vlingo.wire.node.Address;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class SocketChannelWriter {
    private SocketChannel channel;
    private final Address address;
    private final Logger logger;

    public SocketChannelWriter(Address address, Logger logger) {
        this.address = address;
        this.logger = logger;
        this.channel = null;
    }

    public void close() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Exception e) {
                this.logger.error("Channel close failed because: " + e.getMessage(), (Throwable)e);
            }
        }
        this.channel = null;
    }

    public int write(RawMessage message, ByteBuffer buffer) {
        buffer.clear();
        message.copyBytesTo(buffer);
        buffer.flip();
        return this.write(buffer);
    }

    public int write(ByteBuffer buffer) {
        SocketChannel preparedChannel = this.prepareChannel();
        int totalBytesWritten = 0;
        if (preparedChannel != null) {
            try {
                while (buffer.hasRemaining()) {
                    totalBytesWritten += preparedChannel.write(buffer);
                }
            }
            catch (Exception e) {
                this.logger.error("Write to channel failed because: " + e.getMessage(), (Throwable)e);
                this.close();
            }
        }
        return totalBytesWritten;
    }

    public String toString() {
        return "SocketChannelWriter[address=" + this.address + ", channel=" + this.channel + "]";
    }

    private SocketChannel prepareChannel() {
        try {
            if (this.channel != null) {
                if (this.channel.isConnected()) {
                    return this.channel;
                }
            } else {
                this.channel = SocketChannel.open();
                this.channel.connect(new InetSocketAddress(this.address.hostName(), this.address.port()));
                return this.channel;
            }
            this.close();
        }
        catch (Exception e) {
            this.logger.error("" + this + ": Failed to prepare channel because: " + e.getMessage(), (Throwable)e);
            this.close();
        }
        return null;
    }
}

