/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.fdx.bidirectional;

import io.vlingo.actors.Logger;
import io.vlingo.common.pool.ElasticResourcePool;
import io.vlingo.wire.channel.ResponseChannelConsumer;
import io.vlingo.wire.fdx.bidirectional.ClientRequestResponseChannel;
import io.vlingo.wire.message.ConsumerByteBuffer;
import io.vlingo.wire.message.ConsumerByteBufferPool;
import io.vlingo.wire.node.Address;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

@Deprecated
public class BasicClientRequestResponseChannel
implements ClientRequestResponseChannel {
    private final Address address;
    private final ResponseChannelConsumer consumer;
    private final Logger logger;
    private final ConsumerByteBufferPool readBufferPool;
    private SocketChannel channel;
    private int previousPrepareFailures;

    public BasicClientRequestResponseChannel(Address address, ResponseChannelConsumer consumer, int maxBufferPoolSize, int maxMessageSize, Logger logger) throws Exception {
        this.address = address;
        this.consumer = consumer;
        this.logger = logger;
        this.readBufferPool = new ConsumerByteBufferPool(ElasticResourcePool.Config.of((int)maxBufferPoolSize), maxMessageSize);
        this.previousPrepareFailures = 0;
    }

    @Override
    public void close() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Exception e) {
                this.logger.error("Failed to close channel to " + this.address + " because: " + e.getMessage(), (Throwable)e);
            }
        }
        this.channel = null;
    }

    @Override
    public void requestWith(ByteBuffer buffer) {
        SocketChannel preparedChannel = this.preparedChannel();
        if (preparedChannel != null) {
            try {
                while (buffer.hasRemaining()) {
                    preparedChannel.write(buffer);
                }
            }
            catch (Exception e) {
                this.logger.error("Write to socket failed because: " + e.getMessage(), (Throwable)e);
                this.close();
            }
        }
    }

    @Override
    public void probeChannel() {
        try {
            SocketChannel channel = this.preparedChannel();
            if (channel != null) {
                this.readConsume(channel);
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to read channel selector for " + this.address + " because: " + e.getMessage(), (Throwable)e);
        }
    }

    private SocketChannel preparedChannel() {
        block6: {
            try {
                if (this.channel != null) {
                    if (this.channel.isConnected()) {
                        this.previousPrepareFailures = 0;
                        return this.channel;
                    }
                } else {
                    this.channel = SocketChannel.open();
                    this.channel.connect(new InetSocketAddress(this.address.hostName(), this.address.port()));
                    this.channel.configureBlocking(false);
                    this.previousPrepareFailures = 0;
                    return this.channel;
                }
                this.close();
            }
            catch (Exception e) {
                this.close();
                String message = this.getClass().getSimpleName() + ": Cannot prepare/open channel because: " + e.getMessage();
                if (this.previousPrepareFailures == 0) {
                    this.logger.error(message, (Throwable)e);
                }
                if (this.previousPrepareFailures % 20 != 0) break block6;
                this.logger.info("AGAIN: " + message);
            }
        }
        ++this.previousPrepareFailures;
        return null;
    }

    private void readConsume(SocketChannel channel) throws IOException {
        ConsumerByteBuffer pooledBuffer = null;
        ByteBuffer readBuffer = null;
        int totalBytesRead = 0;
        int bytesRead = 0;
        try {
            pooledBuffer = this.readBufferPool.acquire("BasicClientRequestResponseChannel#readConsume");
            readBuffer = pooledBuffer.asByteBuffer();
            do {
                bytesRead = channel.read(readBuffer);
                totalBytesRead += bytesRead;
            } while (bytesRead > 0);
            if (totalBytesRead > 0) {
                this.consumer.consume(pooledBuffer.flip());
            } else {
                pooledBuffer.release();
            }
        }
        catch (Exception e) {
            if (pooledBuffer != null) {
                pooledBuffer.release();
            }
            throw e;
        }
    }
}

