/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.fdx.bidirectional;

import io.vlingo.actors.Logger;
import io.vlingo.common.Tuple3;
import io.vlingo.common.pool.ElasticResourcePool;
import io.vlingo.common.pool.ResourcePool;
import io.vlingo.wire.channel.RefreshableSelector;
import io.vlingo.wire.channel.ResponseChannelConsumer;
import io.vlingo.wire.fdx.bidirectional.ClientRequestResponseChannel;
import io.vlingo.wire.message.ConsumerByteBuffer;
import io.vlingo.wire.message.ConsumerByteBufferPool;
import io.vlingo.wire.node.Address;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SecureClientRequestResponseChannel
implements ClientRequestResponseChannel {
    private final Address address;
    private final SocketChannel channel;
    private final ResponseChannelConsumer consumer;
    private final Logger logger;
    private final ConsumerByteBufferPool readBufferPool;
    private final RefreshableSelector selector;
    private final SSLProvider sslProvider;
    protected final Queue<ByteBuffer> writeQueue;
    private AtomicBoolean closed;

    public SecureClientRequestResponseChannel(Address address, ResponseChannelConsumer consumer, int maxBufferPoolSize, int maxMessageSize, Logger logger) throws Exception {
        logger.debug("SecureClientRequestResponseChannel: Initializing");
        this.address = address;
        this.consumer = consumer;
        this.logger = logger;
        this.readBufferPool = new ConsumerByteBufferPool(ElasticResourcePool.Config.of((int)maxBufferPoolSize), maxMessageSize);
        this.closed = new AtomicBoolean(false);
        this.writeQueue = new ConcurrentLinkedQueue<ByteBuffer>();
        Tuple3<SocketChannel, SSLProvider, RefreshableSelector> quad = this.connect(address);
        this.channel = (SocketChannel)quad._1;
        this.sslProvider = (SSLProvider)quad._2;
        this.selector = (RefreshableSelector)quad._3;
    }

    @Override
    public void close() {
        this.logger.debug("SecureClientRequestResponseChannel: Closing");
        if (!this.isClosed()) {
            try {
                this.selector.close();
                this.channel.close();
            }
            catch (Exception e) {
                this.logger.error("Failed to close channel to " + this.address + " because: " + e.getMessage(), (Throwable)e);
            }
        }
        this.closed.set(true);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void requestWith(ByteBuffer buffer) {
        this.logger.debug("SecureClientRequestResponseChannel: Requesting");
        this.writeQueue.add(buffer);
    }

    @Override
    public void probeChannel() {
        if (this.isClosed()) {
            return;
        }
        try {
            Iterator<SelectionKey> keys = this.selector.selectNow();
            while (keys.hasNext()) {
                ByteBuffer toSend;
                SelectionKey key = keys.next();
                keys.remove();
                if (!key.isValid()) continue;
                if (key.isReadable()) {
                    this.sslProvider.read();
                    continue;
                }
                if (!key.isWritable() || !this.sslProvider.ready.get()) continue;
                while ((toSend = this.writeQueue.poll()) != null) {
                    this.sslProvider.write(toSend);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Failed secure client channel processing for because: " + e.getMessage(), (Throwable)e);
        }
    }

    private Tuple3<SocketChannel, SSLProvider, RefreshableSelector> connect(Address address) throws Exception {
        RefreshableSelector selector = RefreshableSelector.open(address.toString());
        SocketChannel channel = SocketChannel.open();
        InetSocketAddress hostAddress = new InetSocketAddress(address.hostName(), address.port());
        channel.connect(hostAddress);
        channel.configureBlocking(false);
        SelectionKey selectionKey = selector.registerWith(channel, 13);
        ExecutorService worker = Executors.newSingleThreadExecutor();
        ExecutorService taskWorkers = Executors.newFixedThreadPool(2);
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        engine.setUseClientMode(true);
        engine.beginHandshake();
        SSLProvider sslProvider = new SSLProvider(selectionKey, engine, worker, taskWorkers, (ResourcePool<ConsumerByteBuffer, String>)this.readBufferPool);
        return Tuple3.from((Object)channel, (Object)sslProvider, (Object)selector);
    }

    private abstract class SSLWorker
    implements Runnable {
        final SSLEngine engine;
        final Executor ioWorker;
        final Executor taskWorkers;
        final ByteBuffer clientWrap;
        final ByteBuffer clientUnwrap;
        final ByteBuffer serverWrap;
        final ByteBuffer serverUnwrap;
        final ResourcePool<ConsumerByteBuffer, String> readBufferPool;
        private final AtomicBoolean handShakeLock = new AtomicBoolean(false);

        public SSLWorker(SSLEngine engine, Executor ioWorker, Executor taskWorkers, ResourcePool<ConsumerByteBuffer, String> readBufferPool) {
            this.readBufferPool = readBufferPool;
            this.clientWrap = ((ConsumerByteBuffer)readBufferPool.acquire((Object)"SecureClientRequestResponseChannel#SSLWorker#clientWrap")).asByteBuffer();
            this.serverWrap = ((ConsumerByteBuffer)readBufferPool.acquire((Object)"SecureClientRequestResponseChannel#SSLWorker#serverWrap")).asByteBuffer();
            this.clientUnwrap = ((ConsumerByteBuffer)readBufferPool.acquire((Object)"SecureClientRequestResponseChannel#SSLWorker#clientUnwrap")).asByteBuffer();
            this.serverUnwrap = ((ConsumerByteBuffer)readBufferPool.acquire((Object)"SecureClientRequestResponseChannel#SSLWorker#serverUnwrap")).asByteBuffer();
            this.clientUnwrap.limit(0);
            this.engine = engine;
            this.ioWorker = ioWorker;
            this.taskWorkers = taskWorkers;
            this.ioWorker.execute(this);
        }

        public abstract void onInput(ByteBuffer var1);

        public abstract void onOutput(ByteBuffer var1);

        public abstract void onFailure(Exception var1);

        public abstract void onSuccess();

        public abstract void onClosed();

        public void write(final ByteBuffer data) {
            this.ioWorker.execute(new Runnable(){

                @Override
                public void run() {
                    SSLWorker.this.clientWrap.put(data);
                    SSLWorker.this.run();
                }
            });
        }

        public void notify(final ByteBuffer data) {
            this.ioWorker.execute(new Runnable(){

                @Override
                public void run() {
                    SSLWorker.this.clientUnwrap.put(data);
                    SSLWorker.this.run();
                }
            });
        }

        @Override
        public void run() {
            while (this.isHandShaking()) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isHandShaking() {
            try {
                while (!this.handShakeLock.compareAndSet(false, true)) {
                }
                switch (this.engine.getHandshakeStatus()) {
                    case NOT_HANDSHAKING: {
                        boolean occupied = false;
                        if (this.clientWrap.position() > 0) {
                            occupied |= this.wrap();
                        }
                        if (this.clientUnwrap.position() > 0) {
                            occupied |= this.unwrap();
                        }
                        boolean bl = occupied;
                        return bl;
                    }
                    case NEED_WRAP: {
                        if (this.wrap()) break;
                        boolean occupied = false;
                        return occupied;
                    }
                    case NEED_UNWRAP: {
                        if (this.unwrap()) break;
                        boolean occupied = false;
                        return occupied;
                    }
                    case NEED_TASK: {
                        final Runnable sslTask = this.engine.getDelegatedTask();
                        if (sslTask != null) {
                            Runnable wrappedTask = new Runnable(){

                                @Override
                                public void run() {
                                    sslTask.run();
                                    SSLWorker.this.ioWorker.execute(SSLWorker.this);
                                }
                            };
                            this.taskWorkers.execute(wrappedTask);
                            boolean bl = false;
                            return bl;
                        }
                    }
                    case FINISHED: {
                        throw new IllegalStateException("FINISHED");
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.handShakeLock.set(false);
            }
        }

        private boolean wrap() {
            SSLEngineResult wrapResult;
            try {
                this.clientWrap.flip();
                wrapResult = this.engine.wrap(this.clientWrap, this.serverWrap);
                this.clientWrap.compact();
            }
            catch (SSLException exc) {
                this.onFailure(exc);
                return false;
            }
            switch (wrapResult.getStatus()) {
                case OK: {
                    if (this.serverWrap.position() <= 0) break;
                    this.serverWrap.flip();
                    this.onOutput(this.serverWrap);
                    this.serverWrap.compact();
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    break;
                }
                case BUFFER_OVERFLOW: {
                    throw new IllegalStateException("failed to wrap");
                }
                case CLOSED: {
                    SecureClientRequestResponseChannel.this.logger.debug("SecureClientRequestResponseChannel.SSLProvider: wrap closed");
                    this.onClosed();
                    return false;
                }
            }
            return true;
        }

        private boolean unwrap() {
            SSLEngineResult unwrapResult;
            try {
                this.clientUnwrap.flip();
                unwrapResult = this.engine.unwrap(this.clientUnwrap, this.serverUnwrap);
                this.clientUnwrap.compact();
            }
            catch (SSLException ex) {
                this.onFailure(ex);
                return false;
            }
            switch (unwrapResult.getStatus()) {
                case OK: {
                    if (this.serverUnwrap.position() <= 0) break;
                    this.serverUnwrap.flip();
                    this.onInput(this.serverUnwrap);
                    this.serverUnwrap.compact();
                    break;
                }
                case CLOSED: {
                    SecureClientRequestResponseChannel.this.logger.debug("SecureClientRequestResponseChannel.SSLProvider: unwrap closed");
                    this.onClosed();
                    return false;
                }
                case BUFFER_OVERFLOW: {
                    throw new IllegalStateException("failed to unwrap");
                }
                case BUFFER_UNDERFLOW: {
                    return false;
                }
            }
            if (unwrapResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                this.onSuccess();
                return false;
            }
            return true;
        }
    }

    private class SSLProvider
    extends SSLWorker {
        private final ByteBuffer buffer;
        private final SelectionKey key;
        private AtomicBoolean ready;

        public SSLProvider(SelectionKey key, SSLEngine engine, Executor ioWorker, Executor taskWorkers, ResourcePool<ConsumerByteBuffer, String> readBufferPool) {
            super(engine, ioWorker, taskWorkers, readBufferPool);
            this.buffer = ByteBuffer.allocate(32768);
            this.key = key;
            this.ready = new AtomicBoolean(false);
        }

        @Override
        public void onFailure(Exception e) {
            SecureClientRequestResponseChannel.this.logger.error("SecureClientRequestResponseChannel.SSLProvider: Failed Handshake because: " + e.getMessage(), (Throwable)e);
        }

        @Override
        public void onSuccess() {
            SecureClientRequestResponseChannel.this.logger.error("SecureClientRequestResponseChannel.SSLProvider: Handshake Succeeded");
            SSLSession session = this.engine.getSession();
            try {
                this.ready.set(true);
                SecureClientRequestResponseChannel.this.logger.debug("SecureClientRequestResponseChannel.SSLProvider: local principal: " + session.getLocalPrincipal());
                SecureClientRequestResponseChannel.this.logger.debug("SecureClientRequestResponseChannel.SSLProvider: remote principal: " + session.getPeerPrincipal());
                SecureClientRequestResponseChannel.this.logger.debug("SecureClientRequestResponseChannel.SSLProvider: cipher: " + session.getCipherSuite());
            }
            catch (Exception e) {
                SecureClientRequestResponseChannel.this.logger.warn("SecureClientRequestResponseChannel.SSLProvider: Failed Session report because: " + e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void onInput(ByteBuffer decrypted) {
            ConsumerByteBuffer buffer = (ConsumerByteBuffer)this.readBufferPool.acquire((Object)"SecureClientRequestResponseChannel#SSLProvider#onInput");
            SecureClientRequestResponseChannel.this.consumer.consume(buffer.put(decrypted).flip());
        }

        @Override
        public void onOutput(ByteBuffer encrypted) {
            try {
                ((WritableByteChannel)((Object)this.key.channel())).write(encrypted);
            }
            catch (IOException exc) {
                throw new IllegalStateException(exc);
            }
        }

        @Override
        public void onClosed() {
            SecureClientRequestResponseChannel.this.logger.debug("SecureClientRequestResponseChannel.SSLProvider: closed");
        }

        public boolean read() {
            int bytes;
            this.buffer.clear();
            try {
                bytes = ((ReadableByteChannel)((Object)this.key.channel())).read(this.buffer);
            }
            catch (IOException ex) {
                bytes = -1;
            }
            if (bytes == -1) {
                return false;
            }
            this.buffer.flip();
            ByteBuffer copy = ByteBuffer.allocate(bytes);
            copy.put(this.buffer);
            copy.flip();
            this.notify(copy);
            return true;
        }
    }
}

