/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.fdx.bidirectional.netty.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import io.vlingo.common.pool.ElasticResourcePool;
import io.vlingo.wire.channel.ResponseChannelConsumer;
import io.vlingo.wire.message.ConsumerByteBuffer;
import io.vlingo.wire.message.ConsumerByteBufferPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NettyChannelResponseHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(NettyChannelResponseHandler.class);
    private final ResponseChannelConsumer consumer;
    private final ConsumerByteBufferPool readBufferPool;

    NettyChannelResponseHandler(ResponseChannelConsumer consumer, int maxBufferPoolSize, int maxMessageSize) {
        this.consumer = consumer;
        this.readBufferPool = new ConsumerByteBufferPool(ElasticResourcePool.Config.of((int)maxBufferPoolSize), maxMessageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg == null || msg == Unpooled.EMPTY_BUFFER || msg instanceof EmptyByteBuf) {
            return;
        }
        logger.trace("Response received");
        try {
            ConsumerByteBuffer pooledBuffer = this.readBufferPool.acquire("NettyClientChannel#channelRead");
            try {
                ByteBuf byteBuf = (ByteBuf)msg;
                byte[] bytes = new byte[byteBuf.readableBytes()];
                byteBuf.readBytes(bytes);
                pooledBuffer.put(bytes);
                this.consumer.consume(pooledBuffer.flip());
            }
            catch (Throwable t) {
                pooledBuffer.release();
                throw t;
            }
        }
        catch (Throwable throwable) {
            logger.error("Error reading the incoming data.", throwable);
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        logger.error("Unexpected exception", cause);
    }
}

