/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.fdx.bidirectional.netty.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.vlingo.wire.channel.ResponseChannelConsumer;
import io.vlingo.wire.fdx.bidirectional.ClientRequestResponseChannel;
import io.vlingo.wire.fdx.bidirectional.netty.client.NettyChannelResponseHandler;
import io.vlingo.wire.node.Address;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientRequestResponseChannel
implements ClientRequestResponseChannel {
    private static final Logger logger = LoggerFactory.getLogger(NettyClientRequestResponseChannel.class);
    private final Address address;
    private final ResponseChannelConsumer consumer;
    private final int maxBufferPoolSize;
    private final int maxMessageSize;
    private final Duration connectionTimeout;
    private ChannelFuture channelFuture;
    private EventLoopGroup workerGroup;
    private final Duration gracefulShutdownQuietPeriod;
    private final Duration gracefulShutdownTimeout;

    public NettyClientRequestResponseChannel(Address address, ResponseChannelConsumer consumer, int maxBufferPoolSize, int maxMessageSize, Duration connectionTimeout, Duration gracefulShutdownQuietPeriod, Duration gracefulShutdownTimeout) {
        this.address = address;
        this.consumer = consumer;
        this.maxBufferPoolSize = maxBufferPoolSize;
        this.maxMessageSize = maxMessageSize;
        this.connectionTimeout = connectionTimeout;
        this.gracefulShutdownQuietPeriod = gracefulShutdownQuietPeriod;
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
    }

    public NettyClientRequestResponseChannel(Address address, ResponseChannelConsumer consumer, int maxBufferPoolSize, int maxMessageSize) {
        this(address, consumer, maxBufferPoolSize, maxMessageSize, Duration.ofMillis(1000L), Duration.ZERO, Duration.ZERO);
    }

    @Override
    public void close() {
        try {
            if (this.channelFuture != null && this.channelFuture.channel().isActive()) {
                this.channelFuture.channel().close().await().sync();
            }
            if (this.workerGroup != null && !this.workerGroup.isShutdown()) {
                this.workerGroup.shutdownGracefully(this.gracefulShutdownQuietPeriod.toMillis(), this.gracefulShutdownTimeout.toMillis(), TimeUnit.MILLISECONDS).await().sync();
            }
            logger.info("Netty client actor for {} closed", (Object)this.address);
        }
        catch (Throwable throwable) {
            logger.error("Netty client actor for {} was not closed properly", (Object)this.address, (Object)throwable);
        }
    }

    @Override
    public void requestWith(ByteBuffer buffer) {
        this.prepareChannel().ifPresent(channelFuture -> {
            ByteBuf requestByteBuff = channelFuture.channel().alloc().buffer(buffer.limit());
            requestByteBuff.writeBytes(buffer);
            channelFuture.channel().writeAndFlush((Object)requestByteBuff).addListener(future -> {
                if (future.isSuccess()) {
                    logger.trace("Request sent");
                } else {
                    logger.error("Failed to send request", future.cause());
                    this.close();
                }
            });
        });
    }

    @Override
    public void probeChannel() {
        this.prepareChannel();
    }

    private Optional<ChannelFuture> prepareChannel() {
        if (this.workerGroup == null || this.workerGroup.isShutdown()) {
            this.workerGroup = new NioEventLoopGroup();
        }
        if (this.channelFuture == null || this.channelFuture.isCancelled()) {
            try {
                this.channelFuture = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<NioSocketChannel>(){

                    protected void initChannel(NioSocketChannel ch) {
                        ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.TRACE), new MaxMessageSizeSplitter(NettyClientRequestResponseChannel.this.maxMessageSize), new NettyChannelResponseHandler(NettyClientRequestResponseChannel.this.consumer, NettyClientRequestResponseChannel.this.maxBufferPoolSize, NettyClientRequestResponseChannel.this.maxMessageSize)});
                    }
                })).connect(this.address.hostName(), this.address.port()).sync();
                this.channelFuture.await(this.connectionTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.error("Thread Interruption on client channel creation", (Throwable)e);
                Thread.currentThread().interrupt();
                return Optional.empty();
            }
        }
        return Optional.ofNullable(this.channelFuture);
    }

    private static final class MaxMessageSizeSplitter
    extends ByteToMessageDecoder {
        private final int maxMessageSize;

        private MaxMessageSizeSplitter(int maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
            if (in.readableBytes() < this.maxMessageSize) {
                out.add(in.readBytes(in.readableBytes()));
            } else {
                while (in.readableBytes() > 0) {
                    if (in.readableBytes() < this.maxMessageSize) {
                        out.add(in.readBytes(in.readableBytes()));
                        continue;
                    }
                    out.add(in.readBytes(this.maxMessageSize));
                }
            }
        }
    }
}

