/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.fdx.bidirectional.netty.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Stoppable;
import io.vlingo.common.Completes;
import io.vlingo.wire.channel.RequestChannelConsumerProvider;
import io.vlingo.wire.fdx.bidirectional.ServerRequestResponseChannel;
import io.vlingo.wire.fdx.bidirectional.netty.server.NettyInboundHandler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerChannelActor
extends Actor
implements ServerRequestResponseChannel {
    private static final Logger logger = LoggerFactory.getLogger(NettyServerChannelActor.class);
    private final int port;
    private final String name;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ChannelFuture channelFuture;
    private final Duration gracefulShutdownQuietPeriod;
    private final Duration gracefulShutdownTimeout;
    private final OptimalTransport optimalTransport;

    public NettyServerChannelActor(final RequestChannelConsumerProvider provider, int port, String name, int processorPoolSize, final int maxBufferPoolSize, final int maxMessageSize, Duration gracefulShutdownQuietPeriod, Duration gracefulShutdownTimeout) {
        this.port = port;
        this.name = name;
        this.gracefulShutdownQuietPeriod = gracefulShutdownQuietPeriod;
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
        this.optimalTransport = this.optimalTransport();
        this.bossGroup = this.eventLoopGroup();
        this.workerGroup = this.eventLoopGroup(processorPoolSize);
        try {
            ServerBootstrap b = new ServerBootstrap();
            this.channelFuture = ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(this.serverSocketChannelType())).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{new NettyInboundHandler(provider, maxBufferPoolSize, maxMessageSize)});
                }
            }).bind(port).sync();
            logger.info("Netty server {} actor started", (Object)this.name);
        }
        catch (InterruptedException e) {
            logger.error("Netty server {} actor failed to initialize", (Object)this.name, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (this.isStopped()) {
            return;
        }
        ((Stoppable)this.selfAs(Stoppable.class)).stop();
    }

    public void stop() {
        logger.debug("Netty server actor {} will stop", (Object)this.name);
        try {
            if (this.channelFuture.channel().isActive()) {
                this.channelFuture.channel().close().await().sync();
            }
            if (!this.bossGroup.isShutdown()) {
                this.bossGroup.shutdownGracefully(this.gracefulShutdownQuietPeriod.toMillis(), this.gracefulShutdownTimeout.toMillis(), TimeUnit.MILLISECONDS).await().sync();
            }
            if (!this.workerGroup.isShutdown()) {
                this.workerGroup.shutdownGracefully(this.gracefulShutdownQuietPeriod.toMillis(), this.gracefulShutdownTimeout.toMillis(), TimeUnit.MILLISECONDS).await().sync();
            }
            logger.info("Netty server actor {} closed", (Object)this.name);
        }
        catch (Throwable throwable) {
            logger.error("Netty server actor {} was not closed properly", (Object)this.name, (Object)throwable);
        }
        super.stop();
    }

    @Override
    public Completes<Integer> port() {
        return Completes.withSuccess((Object)this.port);
    }

    private EventLoopGroup eventLoopGroup() {
        switch (this.optimalTransport) {
            case Epoll: {
                logger.info("Netty server using EpollEventLoopGroup", (Object)this.name);
                return new EpollEventLoopGroup();
            }
        }
        logger.info("Netty server using NioEventLoopGroup", (Object)this.name);
        return new NioEventLoopGroup();
    }

    private EventLoopGroup eventLoopGroup(int processorPoolSize) {
        switch (this.optimalTransport) {
            case Epoll: {
                logger.info("Netty server using EpollEventLoopGroup " + processorPoolSize, (Object)this.name);
                return new EpollEventLoopGroup(processorPoolSize);
            }
        }
        logger.info("Netty server using NioEventLoopGroup " + processorPoolSize, (Object)this.name);
        return new NioEventLoopGroup(processorPoolSize);
    }

    private OptimalTransport optimalTransport() {
        String osName = System.getProperty("os.name");
        logger.info("Netty server running on " + osName, (Object)this.name);
        if (osName.toLowerCase().contains("linux")) {
            return OptimalTransport.Epoll;
        }
        return OptimalTransport.NIO;
    }

    private Class<? extends ServerSocketChannel> serverSocketChannelType() {
        switch (this.optimalTransport) {
            case Epoll: {
                logger.info("Netty server using EpollServerSocketChannel", (Object)this.name);
                return EpollServerSocketChannel.class;
            }
        }
        logger.info("Netty server using NioServerSocketChannel", (Object)this.name);
        return NioServerSocketChannel.class;
    }

    public static class Instantiator
    implements ActorInstantiator<NettyServerChannelActor> {
        private static final long serialVersionUID = -5114262266054911219L;
        private final RequestChannelConsumerProvider provider;
        private final int port;
        private final String name;
        private final int processorPoolSize;
        private final int maxBufferPoolSize;
        private final int maxMessageSize;
        private final Duration gracefulShutdownQuietPeriod;
        private final Duration gracefulShutdownTimeout;

        public Instantiator(RequestChannelConsumerProvider provider, int port, String name, int processorPoolSize, int maxBufferPoolSize, int maxMessageSize) {
            this(provider, port, name, processorPoolSize, maxBufferPoolSize, maxMessageSize, Duration.ZERO, Duration.ZERO);
        }

        public Instantiator(RequestChannelConsumerProvider provider, int port, String name, int processorPoolSize, int maxBufferPoolSize, int maxMessageSize, Duration gracefulShutdownQuietPeriod, Duration gracefulShutdownTimeout) {
            this.provider = provider;
            this.port = port;
            this.name = name;
            this.processorPoolSize = processorPoolSize;
            this.maxBufferPoolSize = maxBufferPoolSize;
            this.maxMessageSize = maxMessageSize;
            this.gracefulShutdownQuietPeriod = gracefulShutdownQuietPeriod;
            this.gracefulShutdownTimeout = gracefulShutdownTimeout;
        }

        public NettyServerChannelActor instantiate() {
            return new NettyServerChannelActor(this.provider, this.port, this.name, this.processorPoolSize, this.maxBufferPoolSize, this.maxMessageSize, this.gracefulShutdownQuietPeriod, this.gracefulShutdownTimeout);
        }

        public Class<NettyServerChannelActor> type() {
            return NettyServerChannelActor.class;
        }
    }

    private static enum OptimalTransport {
        NIO,
        Epoll;

    }
}

