/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.fdx.inbound;

import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Definition;
import io.vlingo.actors.Stage;
import io.vlingo.actors.Startable;
import io.vlingo.actors.Stoppable;
import io.vlingo.wire.channel.ChannelReader;
import io.vlingo.wire.fdx.inbound.InboundChannelReaderProvider;
import io.vlingo.wire.fdx.inbound.InboundStreamActor;
import io.vlingo.wire.fdx.inbound.InboundStreamInterest;
import io.vlingo.wire.node.AddressType;

public interface InboundStream
extends Startable,
Stoppable {
    public static InboundStream instance(Stage stage, InboundChannelReaderProvider channelReaderProvider, InboundStreamInterest interest, int port, AddressType addressType, String inboundName, long probeInterval) throws Exception {
        ChannelReader channelReader = channelReaderProvider.channelFor(port, inboundName);
        Definition definition = Definition.has(InboundStreamActor.class, (ActorInstantiator)new InboundStreamInstantiator(interest, addressType, channelReader, probeInterval), (String)(inboundName + "-inbound"));
        return (InboundStream)stage.actorFor(InboundStream.class, definition);
    }

    public static class InboundStreamInstantiator
    implements ActorInstantiator<InboundStreamActor> {
        private static final long serialVersionUID = -6324545387015266770L;
        private final AddressType addressType;
        private final ChannelReader channelReader;
        private final InboundStreamInterest interest;
        private final long probeInterval;

        public InboundStreamInstantiator(InboundStreamInterest interest, AddressType addressType, ChannelReader channelReader, long probeInterval) {
            this.interest = interest;
            this.addressType = addressType;
            this.channelReader = channelReader;
            this.probeInterval = probeInterval;
        }

        public InboundStreamActor instantiate() {
            return new InboundStreamActor(this.interest, this.addressType, this.channelReader, this.probeInterval);
        }

        public Class<InboundStreamActor> type() {
            return InboundStreamActor.class;
        }
    }
}

