/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.fdx.inbound;

import io.vlingo.actors.Actor;
import io.vlingo.common.Cancellable;
import io.vlingo.common.Scheduled;
import io.vlingo.wire.channel.ChannelReader;
import io.vlingo.wire.channel.ChannelReaderConsumer;
import io.vlingo.wire.fdx.inbound.InboundStream;
import io.vlingo.wire.fdx.inbound.InboundStreamInterest;
import io.vlingo.wire.message.RawMessage;
import io.vlingo.wire.node.AddressType;

public class InboundStreamActor
extends Actor
implements InboundStream,
ChannelReaderConsumer,
Scheduled<Object> {
    private final AddressType addressType;
    private Cancellable cancellable;
    private final InboundStreamInterest interest;
    private final long probeInterval;
    private final ChannelReader reader;

    public InboundStreamActor(InboundStreamInterest interest, AddressType addressType, ChannelReader reader, long probeInterval) {
        this.interest = interest;
        this.addressType = addressType;
        this.reader = reader;
        this.probeInterval = probeInterval;
    }

    public void intervalSignal(Scheduled<Object> scheduled, Object data) {
        this.reader.probeChannel();
    }

    public void start() {
        if (this.isStopped()) {
            return;
        }
        this.logger().debug("Inbound stream listening: for '" + this.reader.name() + "'");
        try {
            this.reader.openFor(this);
        }
        catch (Exception e) {
            this.reader.close();
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage(), e);
        }
        this.cancellable = this.stage().scheduler().schedule((Scheduled)this.selfAs(Scheduled.class), null, 1000L, this.probeInterval);
    }

    public void stop() {
        if (this.cancellable != null) {
            this.cancellable.cancel();
            this.cancellable = null;
        }
        if (this.reader != null) {
            this.reader.close();
        }
        super.stop();
    }

    @Override
    public void consume(RawMessage message) {
        this.interest.handleInboundStreamMessage(this.addressType, RawMessage.copy(message));
    }
}

