/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.fdx.inbound.rsocket;

import io.rsocket.Closeable;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.server.TcpServerTransport;
import io.vlingo.actors.Logger;
import io.vlingo.wire.channel.ChannelReader;
import io.vlingo.wire.fdx.inbound.InboundChannelReaderProvider;
import io.vlingo.wire.fdx.inbound.rsocket.RSocketChannelInboundReader;
import java.util.function.Function;

public class RSocketInboundChannelReaderProvider
implements InboundChannelReaderProvider {
    private final int maxMessageSize;
    private final Logger logger;
    private final Function<Integer, ServerTransport<? extends Closeable>> serverTransportProvider;

    public RSocketInboundChannelReaderProvider(int maxMessageSize, Logger logger) {
        this.maxMessageSize = maxMessageSize;
        this.logger = logger;
        this.serverTransportProvider = TcpServerTransport::create;
    }

    public RSocketInboundChannelReaderProvider(int maxMessageSize, Logger logger, Function<Integer, ServerTransport<? extends Closeable>> serverTransportProvider) {
        this.maxMessageSize = maxMessageSize;
        this.logger = logger;
        this.serverTransportProvider = serverTransportProvider;
    }

    @Override
    public ChannelReader channelFor(int port, String name) {
        return new RSocketChannelInboundReader(this.serverTransportProvider.apply(port), port, name, this.maxMessageSize, this.logger);
    }
}

