/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.fdx.inbound.tcp;

import io.vlingo.actors.Logger;
import io.vlingo.wire.channel.ChannelMessageDispatcher;
import io.vlingo.wire.channel.ChannelReader;
import io.vlingo.wire.channel.ChannelReaderConsumer;
import io.vlingo.wire.channel.RefreshableSelector;
import io.vlingo.wire.channel.SocketChannelSelectionReader;
import io.vlingo.wire.message.RawMessageBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class SocketChannelInboundReader
implements ChannelReader,
ChannelMessageDispatcher {
    private final ServerSocketChannel channel;
    private boolean closed;
    private ChannelReaderConsumer consumer;
    private final Logger logger;
    private final int maxMessageSize;
    private final String name;
    private final int port;
    private final RefreshableSelector selector;

    public SocketChannelInboundReader(int port, String name, int maxMessageSize, Logger logger) throws Exception {
        this.port = port;
        this.name = name;
        this.channel = ServerSocketChannel.open();
        this.maxMessageSize = maxMessageSize;
        this.logger = logger;
        this.selector = RefreshableSelector.open(name);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.selector.close();
        }
        catch (Exception e) {
            this.logger.error("Failed to close selector for: '" + this.name + "'", (Throwable)e);
        }
        try {
            this.channel.close();
        }
        catch (Exception e) {
            this.logger.error("Failed to close channel for: '" + this.name + "'", (Throwable)e);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public void openFor(ChannelReaderConsumer consumer) throws IOException {
        if (this.closed) {
            return;
        }
        this.consumer = consumer;
        this.logger().debug(this.getClass().getSimpleName() + ": OPENING PORT: " + this.port);
        this.channel.socket().bind(new InetSocketAddress(this.port));
        this.channel.configureBlocking(false);
        this.selector.registerWith(this.channel, 16);
    }

    @Override
    public void probeChannel() {
        if (this.closed) {
            return;
        }
        try {
            Iterator<SelectionKey> iterator = this.selector.selectNow();
            while (iterator.hasNext()) {
                SelectionKey key = iterator.next();
                iterator.remove();
                if (!key.isValid()) continue;
                if (key.isAcceptable()) {
                    this.accept(key);
                    continue;
                }
                if (!key.isReadable()) continue;
                new SocketChannelSelectionReader(this, key).read();
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to read channel selector for: '" + this.name + "'", (Throwable)e);
        }
    }

    @Override
    public ChannelReaderConsumer consumer() {
        return this.consumer;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    public RefreshableSelector __test__only_Selector() {
        return this.selector;
    }

    private void accept(SelectionKey key) throws IOException {
        ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
        if (serverChannel.isOpen()) {
            SocketChannel clientChannel = serverChannel.accept();
            clientChannel.configureBlocking(false);
            SelectionKey clientChannelKey = this.selector.registerWith(clientChannel, 1);
            clientChannelKey.attach(new RawMessageBuilder(this.maxMessageSize));
        }
    }
}

