/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.fdx.outbound;

import io.vlingo.wire.fdx.outbound.ManagedOutboundChannel;
import io.vlingo.wire.fdx.outbound.ManagedOutboundChannelProvider;
import io.vlingo.wire.node.Address;
import io.vlingo.wire.node.AddressType;
import io.vlingo.wire.node.Configuration;
import io.vlingo.wire.node.Id;
import io.vlingo.wire.node.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManagedOutboundChannelProvider
implements ManagedOutboundChannelProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractManagedOutboundChannelProvider.class);
    private final Configuration configuration;
    private final Node node;
    private final Map<Id, ManagedOutboundChannel> nodeChannels = new HashMap<Id, ManagedOutboundChannel>();
    private final AddressType type;

    protected static Address addressOf(Node node, AddressType type) {
        logger.debug("addressOf {}", (Object)node);
        return type == AddressType.OP ? node.operationalAddress() : node.applicationAddress();
    }

    protected AbstractManagedOutboundChannelProvider(Node node, AddressType type, Configuration configuration) {
        this.configuration = configuration;
        this.node = node;
        this.type = type;
    }

    @Override
    public Map<Id, ManagedOutboundChannel> allOtherNodeChannels() {
        return this.channelsFor(this.configuration.allOtherNodes(this.node.id()));
    }

    @Override
    public ManagedOutboundChannel channelFor(Id id) {
        ManagedOutboundChannel channel = this.nodeChannels.get(id);
        if (channel != null) {
            return channel;
        }
        ManagedOutboundChannel unopenedChannel = this.unopenedChannelFor(this.configuration.nodeMatching(id), this.configuration, this.type);
        this.nodeChannels.put(id, unopenedChannel);
        return unopenedChannel;
    }

    @Override
    public Map<Id, ManagedOutboundChannel> channelsFor(Collection<Node> nodes) {
        TreeMap<Id, ManagedOutboundChannel> channels = new TreeMap<Id, ManagedOutboundChannel>();
        for (Node node : nodes) {
            ManagedOutboundChannel channel = this.nodeChannels.get(node.id());
            if (channel == null) {
                channel = this.unopenedChannelFor(node, this.configuration, this.type);
                this.nodeChannels.put(node.id(), channel);
            }
            channels.put(node.id(), channel);
        }
        return channels;
    }

    @Override
    public void close() {
        for (ManagedOutboundChannel channel : this.nodeChannels.values()) {
            channel.close();
        }
        this.nodeChannels.clear();
    }

    @Override
    public void close(Id id) {
        ManagedOutboundChannel channel = this.nodeChannels.remove(id);
        if (channel != null) {
            channel.close();
        }
    }

    @Override
    public void configureKnownChannels() {
        for (Node node : this.configuration.allOtherNodes(this.node.id())) {
            this.nodeChannels.put(node.id(), this.unopenedChannelFor(node, this.configuration, this.type));
        }
    }

    protected abstract ManagedOutboundChannel unopenedChannelFor(Node var1, Configuration var2, AddressType var3);
}

