/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.fdx.outbound;

import io.vlingo.common.pool.ResourcePool;
import io.vlingo.wire.fdx.outbound.ManagedOutboundChannel;
import io.vlingo.wire.fdx.outbound.ManagedOutboundChannelProvider;
import io.vlingo.wire.message.ConsumerByteBuffer;
import io.vlingo.wire.message.RawMessage;
import io.vlingo.wire.node.Id;
import io.vlingo.wire.node.Node;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Outbound {
    private final Logger logger = LoggerFactory.getLogger(Outbound.class);
    private final ResourcePool<ConsumerByteBuffer, String> pool;
    private final ManagedOutboundChannelProvider provider;

    public Outbound(ManagedOutboundChannelProvider provider, ResourcePool<ConsumerByteBuffer, String> byteBufferPool) {
        this.provider = provider;
        this.pool = byteBufferPool;
        this.provider.configureKnownChannels();
    }

    public void broadcast(RawMessage message) {
        this.broadcast(this.bytesFrom(message, (ConsumerByteBuffer)this.pool.acquire((Object)"Outbound#broadcast")));
    }

    public void broadcast(ConsumerByteBuffer buffer) {
        this.broadcast(this.provider.allOtherNodeChannels(), buffer);
    }

    public void broadcast(Collection<Node> selectNodes, RawMessage message) {
        this.broadcast(selectNodes, this.bytesFrom(message, (ConsumerByteBuffer)this.pool.acquire((Object)"Outbound#broadcast")));
    }

    public void broadcast(Collection<Node> selectNodes, ConsumerByteBuffer buffer) {
        this.broadcast(this.provider.channelsFor(selectNodes), buffer);
    }

    public ConsumerByteBuffer bytesFrom(RawMessage message, ConsumerByteBuffer buffer) {
        message.copyBytesTo(buffer.clear().asByteBuffer());
        return buffer.flip();
    }

    public void close() {
        this.provider.close();
    }

    public void close(Id id) {
        this.provider.close(id);
    }

    public ConsumerByteBuffer lendByteBuffer() {
        return (ConsumerByteBuffer)this.pool.acquire((Object)"Outbound#lendByteBuffer");
    }

    public void open(Id id) {
        this.provider.channelFor(id);
    }

    public void sendTo(RawMessage message, Id id) {
        this.sendTo(this.bytesFrom(message, (ConsumerByteBuffer)this.pool.acquire((Object)"Outbound#sendTo")), id);
    }

    public void sendTo(ConsumerByteBuffer buffer, Id id) {
        this.open(id);
        this.provider.channelFor(id).writeAsync(buffer.asByteBuffer()).andFinallyConsume(aVoid -> buffer.release());
    }

    private void broadcast(Map<Id, ManagedOutboundChannel> channels, ConsumerByteBuffer buffer) {
        AtomicInteger latch = new AtomicInteger(channels.size());
        channels.values().forEach(channel -> channel.writeAsync(ByteBuffer.wrap(buffer.array(), buffer.position(), buffer.limit()).asReadOnlyBuffer().order(buffer.order())).andFinallyConsume(ignored -> {
            if (latch.decrementAndGet() == 0) {
                buffer.release();
            }
        }));
    }
}

