/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.fdx.outbound.rsocket;

import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import io.vlingo.wire.fdx.outbound.AbstractManagedOutboundChannelProvider;
import io.vlingo.wire.fdx.outbound.ManagedOutboundChannel;
import io.vlingo.wire.fdx.outbound.rsocket.RSocketOutboundChannel;
import io.vlingo.wire.node.Address;
import io.vlingo.wire.node.AddressType;
import io.vlingo.wire.node.Configuration;
import io.vlingo.wire.node.Node;
import java.time.Duration;
import java.util.function.Function;

public class ManagedOutboundRSocketChannelProvider
extends AbstractManagedOutboundChannelProvider {
    private final Duration connectionTimeout;
    private final Function<Address, ClientTransport> clientTransportProvider;

    private ClientTransport transportFor(Address address) {
        return this.clientTransportProvider.apply(address);
    }

    public ManagedOutboundRSocketChannelProvider(Node node, AddressType type, Configuration configuration) {
        super(node, type, configuration);
        this.clientTransportProvider = address -> TcpClientTransport.create((String)address.hostName(), (int)address.port());
        this.connectionTimeout = Duration.ofMillis(100L);
    }

    public ManagedOutboundRSocketChannelProvider(Node node, AddressType type, Configuration configuration, Duration connectionTimeout, Function<Address, ClientTransport> clientTransportProvider) {
        super(node, type, configuration);
        this.connectionTimeout = connectionTimeout;
        this.clientTransportProvider = clientTransportProvider;
    }

    @Override
    protected ManagedOutboundChannel unopenedChannelFor(Node node, Configuration configuration, AddressType type) {
        Address address = ManagedOutboundRSocketChannelProvider.addressOf(node, type);
        return new RSocketOutboundChannel(address, this.transportFor(address), this.connectionTimeout, configuration.logger());
    }
}

