/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.fdx.outbound.tcp;

import io.vlingo.actors.Logger;
import io.vlingo.wire.fdx.outbound.ManagedOutboundChannel;
import io.vlingo.wire.node.Address;
import io.vlingo.wire.node.Node;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class ManagedOutboundSocketChannel
implements ManagedOutboundChannel {
    private SocketChannel channel;
    private final Address address;
    private final Node node;
    private final Logger logger;

    public ManagedOutboundSocketChannel(Node node, Address address, Logger logger) {
        this.node = node;
        this.address = address;
        this.logger = logger;
        this.channel = null;
    }

    @Override
    public void close() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Exception e) {
                this.logger.error("Close of channel to " + this.node.id() + " failed for because: " + e.getMessage(), (Throwable)e);
            }
        }
        this.channel = null;
    }

    @Override
    public void write(ByteBuffer buffer) {
        SocketChannel preparedChannel = this.preparedChannel();
        if (preparedChannel != null) {
            try {
                while (buffer.hasRemaining()) {
                    preparedChannel.write(buffer);
                }
            }
            catch (Exception e) {
                this.logger.error("Write to " + this.node + " failed because: " + e.getMessage(), (Throwable)e);
                this.close();
            }
        }
    }

    private SocketChannel preparedChannel() {
        try {
            if (this.channel != null) {
                if (this.channel.isConnected()) {
                    return this.channel;
                }
            } else {
                this.channel = SocketChannel.open();
                this.channel.connect(new InetSocketAddress(this.address.hostName(), this.address.port()));
                return this.channel;
            }
            this.close();
        }
        catch (Exception e) {
            this.close();
        }
        return null;
    }
}

