/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.message;

import io.vlingo.common.pool.ElasticResourcePool;
import io.vlingo.common.pool.ResourceFactory;
import io.vlingo.wire.message.BasicConsumerByteBuffer;
import io.vlingo.wire.message.ConsumerByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerByteBufferPool
extends ElasticResourcePool<ConsumerByteBuffer, String> {
    private static final Logger log = LoggerFactory.getLogger(ConsumerByteBufferPool.class);

    public ConsumerByteBuffer acquire() {
        return this.setPool((ConsumerByteBuffer)super.acquire());
    }

    public ConsumerByteBuffer acquire(String string) {
        return this.setPool((ConsumerByteBuffer)super.acquire((Object)string));
    }

    private ConsumerByteBuffer setPool(ConsumerByteBuffer buffer) {
        if (buffer instanceof PoolAwareConsumerByteBuffer) {
            PoolAwareConsumerByteBuffer pooledBuffer = (PoolAwareConsumerByteBuffer)buffer;
            pooledBuffer.setPool(this);
            pooledBuffer.activate();
        }
        return buffer;
    }

    public ConsumerByteBufferPool(ElasticResourcePool.Config config, int maxBufferSize) {
        super(config, (ResourceFactory)new ConsumerByteBufferFactory(maxBufferSize));
    }

    private static final class PoolAwareConsumerByteBuffer
    extends BasicConsumerByteBuffer {
        private ConsumerByteBufferPool pool;
        private final AtomicBoolean active = new AtomicBoolean(true);

        PoolAwareConsumerByteBuffer(int id, int maxBufferSize) {
            super(id, maxBufferSize);
        }

        void setPool(ConsumerByteBufferPool pool) {
            this.pool = pool;
        }

        void activate() {
            this.active.set(true);
        }

        @Override
        public String toString() {
            return "PooledByteBuffer[id=" + this.id() + "]";
        }

        @Override
        public void release() {
            if (this.active.compareAndSet(true, false)) {
                this.pool.release(this);
            } else {
                String message = String.format("Attempt to release the same buffer [%d:%s] more than once", this.id(), this.tag());
                if (!log.isDebugEnabled()) {
                    log.warn(message);
                } else {
                    log.debug(message, (Throwable)new IllegalStateException(new IllegalStateException("Buffer already released")));
                }
            }
        }
    }

    private static final class ConsumerByteBufferFactory
    implements ResourceFactory<ConsumerByteBuffer, String> {
        private static final AtomicInteger idSequence = new AtomicInteger(0);
        private final int maxBufferSize;

        private ConsumerByteBufferFactory(int maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
        }

        public Class<ConsumerByteBuffer> type() {
            return ConsumerByteBuffer.class;
        }

        public ConsumerByteBuffer create(String string) {
            PoolAwareConsumerByteBuffer poolAwareConsumerByteBuffer = new PoolAwareConsumerByteBuffer(idSequence.incrementAndGet(), this.maxBufferSize);
            poolAwareConsumerByteBuffer.tag(string);
            return poolAwareConsumerByteBuffer;
        }

        public String defaultArguments() {
            return "notag";
        }

        public ConsumerByteBuffer reset(ConsumerByteBuffer buffer, String string) {
            if (buffer instanceof BasicConsumerByteBuffer) {
                BasicConsumerByteBuffer basicConsumerByteBuffer = (BasicConsumerByteBuffer)buffer;
                basicConsumerByteBuffer.tag(string);
            }
            return buffer.clear();
        }

        public void destroy(ConsumerByteBuffer buffer) {
        }
    }
}

