/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.message;

import io.vlingo.wire.message.RawMessage;
import io.vlingo.wire.message.RawMessageHeader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Converters {
    private static Charset CHARSET_VALUE = Charset.forName(StandardCharsets.UTF_8.name());

    public static String bytesToText(byte[] bytes, int index, int length) {
        return new String(bytes, index, length, CHARSET_VALUE);
    }

    public static void changeCharset(String charsetName) {
        CHARSET_VALUE = Charset.forName(charsetName);
    }

    public static byte[] textToBytes(String text) {
        return text.getBytes(CHARSET_VALUE);
    }

    public static RawMessage toRawMessage(short sendingNodeId, ByteBuffer buffer) {
        buffer.flip();
        RawMessage message = new RawMessage(buffer.limit());
        message.put(buffer, false);
        buffer.clear();
        RawMessageHeader header = new RawMessageHeader(sendingNodeId, 0, (int)((short)message.length()));
        message.header(header);
        return message;
    }
}

