/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.message;

import io.vlingo.wire.node.Address;
import io.vlingo.wire.node.AddressType;
import io.vlingo.wire.node.Id;
import io.vlingo.wire.node.Name;
import io.vlingo.wire.node.Node;
import java.util.HashSet;
import java.util.Set;

public class MessagePartsBuilder {
    public static final Address addressFromRecord(String record, AddressType type) {
        String text = MessagePartsBuilder.parseField(record, type.field());
        if (text == null) {
            return Address.NO_NODE_ADDRESS;
        }
        return Address.from(text, type);
    }

    public static final Set<Address> addressesFromRecord(String record, AddressType type) {
        HashSet<Address> addresses = new HashSet<Address>();
        String[] parts = record.split("\n");
        if (parts.length < 3) {
            return addresses;
        }
        for (int index = 2; index < parts.length; ++index) {
            addresses.add(MessagePartsBuilder.addressFromRecord(parts[index], type));
        }
        return addresses;
    }

    public static final Set<Node> nodesFrom(String content) {
        HashSet<Node> nodeEntries = new HashSet<Node>();
        String[] parts = content.split("\n");
        if (parts.length < 3) {
            return nodeEntries;
        }
        for (int index = 2; index < parts.length; ++index) {
            nodeEntries.add(MessagePartsBuilder.nodeFromRecord(parts[index]));
        }
        return nodeEntries;
    }

    public static final Node nodeFrom(String content) {
        String[] parts = content.split("\n");
        if (parts.length < 2) {
            return Node.NO_NODE;
        }
        return MessagePartsBuilder.nodeFromRecord(parts[1]);
    }

    public static final Node nodeFromRecord(String record) {
        Id id = MessagePartsBuilder.idFromRecord(record);
        Name name = MessagePartsBuilder.nameFromRecord(record);
        Address opAddress = MessagePartsBuilder.addressFromRecord(record, AddressType.OP);
        Address appAddress = MessagePartsBuilder.addressFromRecord(record, AddressType.APP);
        return new Node(id, name, opAddress, appAddress);
    }

    public static final Id idFrom(String content) {
        String[] parts = content.split("\n");
        if (parts.length < 2) {
            return Id.NO_ID;
        }
        return MessagePartsBuilder.idFromRecord(parts[1]);
    }

    public static final Id idFromRecord(String record) {
        String text = MessagePartsBuilder.parseField(record, "id=");
        if (text == null) {
            return Id.NO_ID;
        }
        return Id.of(Short.parseShort(text));
    }

    public static final Name nameFrom(String content) {
        String[] parts = content.split("\n");
        if (parts.length < 2) {
            return Name.NO_NODE_NAME;
        }
        return MessagePartsBuilder.nameFromRecord(parts[1]);
    }

    public static final Name nameFromRecord(String record) {
        String text = MessagePartsBuilder.parseField(record, "nm=");
        if (text == null) {
            return Name.NO_NODE_NAME;
        }
        return new Name(text);
    }

    public static final String parseField(String record, String fieldName) {
        int space;
        String skinnyRecord = record.trim();
        int idIndex = skinnyRecord.indexOf(fieldName);
        if (idIndex == -1) {
            return null;
        }
        int valueIndex = idIndex + fieldName.length();
        if (valueIndex >= (space = skinnyRecord.indexOf(32, valueIndex))) {
            return skinnyRecord.substring(valueIndex);
        }
        return skinnyRecord.substring(valueIndex, space);
    }
}

