/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.message;

import io.vlingo.wire.message.MessagePartsBuilder;
import io.vlingo.wire.node.Address;
import io.vlingo.wire.node.AddressType;
import io.vlingo.wire.node.Host;
import io.vlingo.wire.node.Name;

public class PublisherAvailability {
    public static final String TypeName = "PUB";
    private final String host;
    private final String name;
    private final int port;

    public static PublisherAvailability from(String content) {
        if (content.startsWith(TypeName)) {
            Name name = MessagePartsBuilder.nameFrom(content);
            AddressType type = AddressType.MAIN;
            Address address = MessagePartsBuilder.addressFromRecord(content, type);
            return new PublisherAvailability(name.value(), address.host().name(), address.port());
        }
        return new PublisherAvailability("?", "", 0);
    }

    public PublisherAvailability(String name, String host, int port) {
        this.name = name;
        this.host = host;
        this.port = port;
    }

    public boolean isValid() {
        return !this.name.equals("?");
    }

    public Address toAddress() {
        return this.toAddress(AddressType.MAIN);
    }

    public Address toAddress(AddressType type) {
        return Address.from(Host.of(this.host), this.port, type);
    }

    public int hashCode() {
        return 31 * (this.name.hashCode() + this.host.hashCode() + this.port);
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != PublisherAvailability.class) {
            return false;
        }
        PublisherAvailability otherPA = (PublisherAvailability)other;
        return this.name.equals(otherPA.name) && this.host.equals(otherPA.host) && this.port == otherPA.port;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PUB\n").append("nm=").append(this.name).append(" addr=").append(this.host).append(":").append(this.port);
        return builder.toString();
    }
}

