/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.message;

import io.vlingo.wire.message.ByteBufferAllocator;
import io.vlingo.wire.message.Converters;
import io.vlingo.wire.message.RawMessageHeader;
import java.nio.ByteBuffer;

public class RawMessage {
    private final byte[] bytes;
    private RawMessageHeader header;
    private int index;

    public static RawMessage copy(RawMessage original) {
        return new RawMessage(original);
    }

    public static RawMessage from(int nodeId, int type, int length) {
        return new RawMessage(RawMessageHeader.from(nodeId, type, length), length);
    }

    public static RawMessage from(int nodeId, int type, String textMessage) {
        byte[] textBytes = Converters.textToBytes(textMessage);
        RawMessageHeader header = RawMessageHeader.from(nodeId, type, textBytes.length);
        RawMessage message = new RawMessage(header, textBytes.length);
        message.append(textBytes, 0, textBytes.length);
        return message;
    }

    public static RawMessage readFromWithHeader(ByteBuffer buffer) {
        RawMessageHeader header = RawMessageHeader.from(buffer);
        RawMessage message = new RawMessage(header, header.length());
        message.putRemaining(buffer);
        return message;
    }

    public static RawMessage readFromWithoutHeader(ByteBuffer buffer) {
        RawMessageHeader header = RawMessageHeader.from(0, 0, buffer.limit());
        RawMessage message = new RawMessage(header, header.length());
        message.putRemaining(buffer);
        return message;
    }

    public RawMessage(RawMessageHeader header, int maxMessageSize) {
        this.bytes = new byte[maxMessageSize];
        this.header = header;
        this.index = 0;
    }

    public RawMessage(int maxMessageSize) {
        this(new RawMessageHeader(), maxMessageSize);
    }

    public RawMessage(byte[] bytes) {
        this.bytes = bytes;
        this.header = new RawMessageHeader();
        this.index = bytes.length;
    }

    public RawMessage(RawMessage copy) {
        this(copy.length());
        this.append(copy.bytes, 0, copy.length());
        this.header(RawMessageHeader.from(copy.header));
    }

    public void append(byte[] sourceBytes, int sourceIndex, int sourceLength) {
        System.arraycopy(sourceBytes, sourceIndex, this.bytes, this.index, sourceLength);
        this.index += sourceLength;
    }

    public final byte[] asBinaryMessage() {
        return this.bytes;
    }

    public final ByteBuffer asByteBuffer() {
        return this.asByteBuffer(ByteBufferAllocator.allocate(14 + this.bytes.length));
    }

    public final ByteBuffer asByteBuffer(ByteBuffer buffer) {
        buffer.clear();
        this.copyBytesTo(buffer);
        buffer.flip();
        return buffer;
    }

    public final String asTextMessage() {
        return Converters.bytesToText(this.bytes, 0, this.length());
    }

    public void copyBytesTo(ByteBuffer buffer) {
        this.header.copyBytesTo(buffer);
        buffer.put(this.bytes);
    }

    public RawMessage from(ByteBuffer buffer) {
        this.headerFrom(buffer);
        this.putRemaining(buffer);
        return this;
    }

    public final RawMessageHeader header() {
        return this.header;
    }

    public void header(RawMessageHeader header) {
        this.header = header;
    }

    public void headerFrom(ByteBuffer buffer) {
        this.header.read(buffer);
    }

    public int length() {
        return this.index;
    }

    public void put(ByteBuffer buffer, boolean flip) {
        if (flip) {
            buffer.flip();
        }
        int length = buffer.limit();
        System.arraycopy(buffer.array(), 0, this.bytes, 0, length);
        this.index = length;
    }

    public void put(ByteBuffer buffer) {
        this.put(buffer, true);
    }

    public void putRemaining(ByteBuffer buffer) {
        int position = buffer.position();
        int length = buffer.limit() - position;
        System.arraycopy(buffer.array(), position, this.bytes, 0, length);
        this.index = length;
    }

    public int requiredMessageLength() {
        return this.header.length();
    }

    public final RawMessage reset() {
        this.index = 0;
        return this;
    }

    public String toString() {
        return "RawMessage[header=" + this.header + " length=" + this.length() + "]";
    }

    public int totalLength() {
        return 14 + this.length();
    }
}

