/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.message;

import io.vlingo.wire.message.ByteBufferAllocator;
import io.vlingo.wire.message.RawMessage;
import java.nio.ByteBuffer;

public class RawMessageBuilder {
    private ScanMode mode;
    private final RawMessage rawMessage;
    private final ByteBuffer workBuffer;

    public RawMessageBuilder(int maxMessageSize) {
        this.rawMessage = new RawMessage(maxMessageSize);
        this.workBuffer = ByteBufferAllocator.allocate(maxMessageSize);
        this.mode = ScanMode.READ_HEADER;
    }

    public final RawMessage currentRawMessage() {
        if (this.isCurrentMessageIncomplete()) {
            throw new IllegalStateException("The current raw message is incomplete.");
        }
        return this.rawMessage;
    }

    public boolean hasContent() {
        return this.workBuffer.position() > 0;
    }

    public boolean isCurrentMessageComplete() {
        int length = this.length();
        int expected = this.rawMessage.requiredMessageLength();
        return length != 0 && length == expected;
    }

    public boolean isCurrentMessageIncomplete() {
        return this.length() < this.rawMessage.requiredMessageLength();
    }

    public int length() {
        return this.rawMessage.length();
    }

    public RawMessageBuilder prepareContent() {
        this.workBuffer.flip();
        return this;
    }

    public RawMessageBuilder prepareForNextMessage() {
        this.rawMessage.reset();
        return this;
    }

    public void sync() {
        if (!this.underflow()) {
            byte[] content = this.workBuffer.array();
            if (this.mode.isReadHeaderMode()) {
                this.rawMessage.headerFrom(this.workBuffer);
            }
            int messageTotalLength = this.rawMessage.requiredMessageLength();
            int missingRawMessageLength = messageTotalLength - this.rawMessage.length();
            int contentPosition = this.workBuffer.position();
            int availableContentLength = this.workBuffer.limit() - contentPosition;
            int appendLength = Math.min(missingRawMessageLength, availableContentLength);
            this.rawMessage.append(content, contentPosition, appendLength);
            this.workBuffer.position(contentPosition + appendLength);
            if (availableContentLength == missingRawMessageLength) {
                this.workBuffer.clear();
                this.setMode(ScanMode.READ_HEADER);
            } else if (availableContentLength > missingRawMessageLength) {
                this.setMode(ScanMode.READ_HEADER);
            } else if (availableContentLength < missingRawMessageLength) {
                this.workBuffer.clear();
                this.setMode(ScanMode.REUSE_HEADER);
            }
        }
    }

    public final ByteBuffer workBuffer() {
        return this.workBuffer;
    }

    private void setMode(ScanMode mode) {
        this.mode = mode;
    }

    private boolean underflow() {
        int remainingContentLength = this.workBuffer.limit() - this.workBuffer.position();
        int minimumRequiredLength = 15;
        if (this.rawMessage.requiredMessageLength() == 0 && remainingContentLength < 15) {
            byte[] content = this.workBuffer.array();
            System.arraycopy(content, this.workBuffer.position(), content, 0, remainingContentLength);
            this.workBuffer.position(0);
            this.workBuffer.limit(remainingContentLength);
            this.setMode(ScanMode.READ_HEADER);
            return true;
        }
        return false;
    }

    private static enum ScanMode {
        READ_HEADER,
        REUSE_HEADER;


        boolean isReadHeaderMode() {
            return this == READ_HEADER;
        }
    }
}

