/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.message;

import java.nio.ByteBuffer;

public final class RawMessageHeader {
    private static final int SHORT_FIELDS = 5;
    private static final int INT_FIELDS = 1;
    private static final int SHORT_BYTES = 2;
    private static final int INT_BYTES = 4;
    public static final int BYTES = 14;
    private static final short HEADER_ID = 3731;
    private int length;
    private short nodeId;
    private short type;

    public static final RawMessageHeader from(ByteBuffer buffer) {
        RawMessageHeader header = new RawMessageHeader();
        return header.read(buffer);
    }

    public static final RawMessageHeader from(short nodeId, short type, int length) {
        return new RawMessageHeader(nodeId, type, length);
    }

    public static final RawMessageHeader from(short nodeId, int type, int length) {
        return new RawMessageHeader(nodeId, (short)type, length);
    }

    public static final RawMessageHeader from(int nodeId, int type, int length) {
        return new RawMessageHeader((short)nodeId, (short)type, length);
    }

    public static final RawMessageHeader from(RawMessageHeader copy) {
        return RawMessageHeader.from(copy.nodeId, copy.type, copy.length);
    }

    public RawMessageHeader() {
        this(-1, -1, -1);
    }

    public RawMessageHeader(short nodeId, short type, int length) {
        this.nodeId = nodeId;
        this.type = type;
        this.length = length;
    }

    public RawMessageHeader(int nodeId, int type, int length) {
        this((short)nodeId, (short)type, length);
    }

    public int length() {
        return this.length;
    }

    public short nodeId() {
        return this.nodeId;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != RawMessageHeader.class) {
            return false;
        }
        RawMessageHeader otherHeader = (RawMessageHeader)other;
        return this.nodeId == otherHeader.nodeId && this.type == otherHeader.type && this.length == otherHeader.length;
    }

    public String toString() {
        return "RawMessageHeader[headerId=3731 nodeId=" + this.nodeId + " type=" + this.type + " length=" + this.length + "]";
    }

    public short type() {
        return this.type;
    }

    public void copyBytesTo(ByteBuffer buffer) {
        buffer.putShort((short)3731).putShort(this.nodeId).putShort(this.type).putInt(this.length).putShort((short)Short.MAX_VALUE).putShort((short)Short.MAX_VALUE);
    }

    public final RawMessageHeader read(ByteBuffer buffer) {
        short headerId = buffer.getShort();
        if (headerId != 3731) {
            throw new IllegalArgumentException("Invalid raw message header: " + headerId);
        }
        short nodeId = buffer.getShort();
        short type = buffer.getShort();
        int length = buffer.getInt();
        buffer.getShort();
        buffer.getShort();
        return this.setAll(nodeId, type, length);
    }

    protected final RawMessageHeader setAll(short nodeId, short type, int length) {
        this.nodeId = nodeId;
        this.type = type;
        this.length = length;
        return this;
    }
}

