/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.multicast;

import io.vlingo.actors.Logger;
import io.vlingo.wire.channel.ChannelMessageDispatcher;
import io.vlingo.wire.channel.ChannelPublisher;
import io.vlingo.wire.channel.ChannelReaderConsumer;
import io.vlingo.wire.channel.RefreshableSelector;
import io.vlingo.wire.channel.SocketChannelSelectionReader;
import io.vlingo.wire.message.ByteBufferAllocator;
import io.vlingo.wire.message.PublisherAvailability;
import io.vlingo.wire.message.RawMessage;
import io.vlingo.wire.message.RawMessageBuilder;
import io.vlingo.wire.multicast.Group;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class MulticastPublisherReader
implements ChannelPublisher,
ChannelMessageDispatcher {
    private final RawMessage availability;
    private final DatagramChannel publisherChannel;
    private boolean closed;
    private final ChannelReaderConsumer consumer;
    private final InetSocketAddress groupAddress;
    private final Logger logger;
    private final ByteBuffer messageBuffer;
    private final Queue<RawMessage> messageQueue;
    private final String name;
    private final InetSocketAddress publisherAddress;
    private final ServerSocketChannel readChannel;
    private final RefreshableSelector selector;

    public MulticastPublisherReader(String name, Group group, int incomingSocketPort, int maxMessageSize, ChannelReaderConsumer consumer, Logger logger) throws Exception {
        this.name = name;
        this.groupAddress = new InetSocketAddress(InetAddress.getByName(group.address()), group.port());
        this.consumer = consumer;
        this.logger = logger;
        this.messageBuffer = ByteBufferAllocator.allocate(maxMessageSize);
        this.messageQueue = new LinkedList<RawMessage>();
        this.publisherChannel = DatagramChannel.open();
        this.selector = RefreshableSelector.open(name);
        this.publisherChannel.bind(null);
        this.publisherChannel.configureBlocking(false);
        this.selector.registerWith(this.publisherChannel, 4);
        this.readChannel = ServerSocketChannel.open();
        this.readChannel.socket().bind(new InetSocketAddress(incomingSocketPort));
        this.readChannel.configureBlocking(false);
        this.selector.registerWith(this.readChannel, 16);
        this.publisherAddress = (InetSocketAddress)this.readChannel.socket().getLocalSocketAddress();
        this.availability = this.availabilityMessage();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.selector.close();
        }
        catch (Exception e) {
            this.logger.error("Failed to close multicast publisher selector for: '" + this.name + "'", (Throwable)e);
        }
        try {
            this.publisherChannel.close();
        }
        catch (Exception e) {
            this.logger.error("Failed to close multicast publisher channel for: '" + this.name + "'", (Throwable)e);
        }
        try {
            this.readChannel.close();
        }
        catch (Exception e) {
            this.logger.error("Failed to close multicast reader channel for: '" + this.name + "'", (Throwable)e);
        }
    }

    @Override
    public void processChannel() {
        if (this.closed) {
            return;
        }
        try {
            Iterator<SelectionKey> iterator = this.selector.selectNow();
            while (iterator.hasNext()) {
                SelectionKey key = iterator.next();
                iterator.remove();
                if (!key.isValid()) continue;
                if (key.isAcceptable()) {
                    this.accept(key);
                    continue;
                }
                if (key.isWritable()) {
                    this.sendMax();
                    continue;
                }
                if (!key.isReadable()) continue;
                this.receive(key);
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to read channel selector for: '" + this.name + "'", (Throwable)e);
        }
    }

    @Override
    public void sendAvailability() {
        this.send(this.availability);
    }

    @Override
    public void send(RawMessage message) {
        int length = message.length();
        if (length <= 0) {
            throw new IllegalArgumentException("The message length must be greater than zero.");
        }
        if (length > this.messageBuffer.capacity()) {
            throw new IllegalArgumentException("The message length is greater than " + this.messageBuffer.capacity());
        }
        this.messageQueue.add(message);
    }

    @Override
    public ChannelReaderConsumer consumer() {
        return this.consumer;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public String name() {
        return this.name;
    }

    private void accept(SelectionKey key) throws IOException {
        ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
        if (serverChannel.isOpen()) {
            SocketChannel clientChannel = serverChannel.accept();
            clientChannel.configureBlocking(false);
            SelectionKey clientChannelKey = this.selector.registerWith(clientChannel, 1);
            clientChannelKey.attach(new RawMessageBuilder(this.messageBuffer.capacity()));
        }
    }

    private RawMessage availabilityMessage() {
        String message = new PublisherAvailability(this.name, this.publisherAddress.getHostName(), this.publisherAddress.getPort()).toString();
        ByteBuffer buffer = ByteBufferAllocator.allocate(message.length());
        buffer.put(message.getBytes());
        buffer.flip();
        return RawMessage.readFromWithoutHeader(buffer);
    }

    private void receive(SelectionKey key) throws IOException {
        new SocketChannelSelectionReader(this, key).read();
    }

    private void sendMax() throws IOException {
        while (true) {
            RawMessage message;
            if ((message = this.messageQueue.peek()) == null) {
                return;
            }
            if (this.publisherChannel.send(message.asByteBuffer(this.messageBuffer), this.groupAddress) <= 0) break;
            this.messageQueue.remove();
        }
    }
}

