/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.multicast;

import io.vlingo.actors.Logger;
import io.vlingo.wire.channel.ChannelMessageDispatcher;
import io.vlingo.wire.channel.ChannelReader;
import io.vlingo.wire.channel.ChannelReaderConsumer;
import io.vlingo.wire.message.ByteBufferAllocator;
import io.vlingo.wire.message.RawMessage;
import io.vlingo.wire.multicast.Group;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.util.Enumeration;

public class MulticastSubscriber
implements ChannelReader,
ChannelMessageDispatcher {
    private final ByteBuffer buffer;
    private boolean closed;
    private final DatagramChannel channel;
    private ChannelReaderConsumer consumer;
    private final InetAddress groupAddress;
    private final Logger logger;
    private final int maxReceives;
    private final MembershipKey membershipKey;
    private final RawMessage message;
    private final String name;
    private final NetworkInterface networkInterface;
    private final int port;

    public MulticastSubscriber(String name, Group group, int maxMessageSize, int maxReceives, Logger logger) throws IOException {
        this(name, group, null, maxMessageSize, maxReceives, logger);
    }

    public MulticastSubscriber(String name, Group group, String networkInterfaceName, int maxMessageSize, int maxReceives, Logger logger) throws IOException {
        this.name = name;
        this.logger = logger;
        this.channel = DatagramChannel.open(StandardProtocolFamily.INET);
        this.channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.port = group.port();
        this.channel.bind(new InetSocketAddress(this.port));
        this.networkInterface = this.assignNetworkInterfaceTo(this.channel, networkInterfaceName);
        this.groupAddress = InetAddress.getByName(group.address());
        this.membershipKey = this.channel.join(this.groupAddress, this.networkInterface);
        this.channel.configureBlocking(false);
        this.buffer = ByteBufferAllocator.allocate(maxMessageSize);
        this.message = new RawMessage(maxMessageSize);
        this.maxReceives = maxReceives;
        logger.info("MulticastSubscriber joined: " + this.membershipKey);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.channel.close();
        }
        catch (Exception e) {
            this.logger.error("Failed to close channel for: '" + this.name + "'", (Throwable)e);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public void openFor(ChannelReaderConsumer consumer) throws IOException {
        if (this.closed) {
            return;
        }
        this.consumer = consumer;
    }

    @Override
    public void probeChannel() {
        if (this.closed) {
            return;
        }
        try {
            for (int receives = 0; receives < this.maxReceives; ++receives) {
                this.buffer.clear();
                SocketAddress sourceAddress = this.channel.receive(this.buffer);
                if (sourceAddress == null) continue;
                this.buffer.flip();
                this.message.from(this.buffer);
                this.consumer.consume(this.message);
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to read channel selector for: '" + this.name + "'", (Throwable)e);
        }
    }

    @Override
    public ChannelReaderConsumer consumer() {
        return this.consumer;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    private NetworkInterface assignNetworkInterfaceTo(DatagramChannel channel, String networkInterfaceName) throws IOException {
        NetworkInterface specified;
        if (networkInterfaceName != null && !networkInterfaceName.trim().isEmpty() && (specified = NetworkInterface.getByName(networkInterfaceName)) != null) {
            channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, specified);
            return specified;
        }
        return this.assignBestGuessNetworkInterfaceTo(channel);
    }

    private NetworkInterface assignBestGuessNetworkInterfaceTo(DatagramChannel channel) throws IOException {
        NetworkInterface networkInterface = null;
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface candidate = networkInterfaces.nextElement();
            String candidateName = candidate.getName().toLowerCase();
            if (candidateName.contains("virtual") || candidateName.startsWith("v") || !candidate.isUp() || candidate.isLoopback() || candidate.isPointToPoint() || candidate.isVirtual()) continue;
            try {
                channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, candidate);
                networkInterface = candidate;
                break;
            }
            catch (IOException e) {
                networkInterface = null;
            }
        }
        if (networkInterface == null) {
            throw new IOException("Cannot assign network interface");
        }
        return networkInterface;
    }
}

