/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.node;

import io.vlingo.wire.node.AddressType;
import io.vlingo.wire.node.Host;

public final class Address {
    public static final String NO_HOST = "?";
    public static final int NO_PORT = -1;
    public static final Address NO_NODE_ADDRESS = new Address(Host.of("?"), -1, AddressType.NONE);
    private final Host host;
    private final int port;
    private final AddressType type;

    public static Address from(String fullAddress, AddressType type) {
        int lastColon = fullAddress.lastIndexOf(":");
        if (lastColon == -1) {
            throw new IllegalArgumentException("The address is not valid: " + fullAddress);
        }
        return new Address(Host.of(fullAddress.substring(0, lastColon)), Integer.parseInt(fullAddress.substring(lastColon + 1)), type);
    }

    public static Address from(Host host, int port, AddressType type) {
        return new Address(host, port, type);
    }

    public Address(Host host, int port, AddressType type) {
        this.host = host;
        this.port = port;
        this.type = type;
    }

    public String full() {
        return this.host.name() + ":" + this.port;
    }

    public final Host host() {
        return this.host;
    }

    public final String hostName() {
        return this.host.name();
    }

    public boolean hasNoAddress() {
        return this.host().name().equals(NO_HOST) || this.port() == -1;
    }

    public boolean isValid() {
        return !this.hasNoAddress();
    }

    public int port() {
        return this.port;
    }

    public AddressType type() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != Address.class) {
            return false;
        }
        return this.host.equals(((Address)other).host);
    }

    public int hashCode() {
        return 31 * this.host.hashCode();
    }

    public String toString() {
        return "Address[" + this.host + "," + this.port + "," + (Object)((Object)this.type) + "]";
    }
}

