/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.node;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

public final class Id
implements Comparable<Id>,
Serializable {
    private static final long serialVersionUID = 4159344356315659962L;
    public static final short UNDEFINED_ID = -1;
    public static final Id NO_ID = Id.of((short)-1);
    private final short value;

    public static Id of(int id) {
        return new Id(id);
    }

    public static Id of(short id) {
        return new Id(id);
    }

    public Id(short id) {
        this.value = id;
    }

    public Id(int id) {
        this((short)id);
    }

    public Collection<Id> collected() {
        return Arrays.asList(this);
    }

    public boolean hasNoId() {
        return this.value == -1;
    }

    public short value() {
        return this.value;
    }

    public String valueString() {
        return String.valueOf(this.value);
    }

    public boolean isValid() {
        return !this.hasNoId();
    }

    public int toInteger() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != Id.class) {
            return false;
        }
        return this.value == ((Id)other).value;
    }

    public int hashCode() {
        return 31 * this.value;
    }

    public String toString() {
        return "Id[" + this.value + "]";
    }

    @Override
    public int compareTo(Id other) {
        return Short.compare(this.value, other.value);
    }

    public boolean greaterThan(Id other) {
        return this.value > other.value;
    }
}

