/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.wire.node;

import io.vlingo.wire.node.Address;
import io.vlingo.wire.node.AddressType;
import io.vlingo.wire.node.Host;
import io.vlingo.wire.node.Id;
import io.vlingo.wire.node.Name;
import java.util.Arrays;
import java.util.Collection;

public final class Node
implements Comparable<Node> {
    public static Node NO_NODE = new Node(Id.NO_ID, Name.NO_NODE_NAME, Address.NO_NODE_ADDRESS, Address.NO_NODE_ADDRESS);
    private final Id id;
    private final Name name;
    private final Address operationalAddress;
    private final Address applicationAddress;

    public static Node with(Id id, Name name, Host host, int operationalPort, int applicationPort) {
        Address operationalAddress = new Address(host, operationalPort, AddressType.OP);
        Address applicationAddress = new Address(host, applicationPort, AddressType.APP);
        return new Node(id, name, operationalAddress, applicationAddress);
    }

    public Node(Id id, Name nodeName, Address operationalAddress, Address applicationAddress) {
        this.id = id;
        this.name = nodeName;
        this.operationalAddress = operationalAddress;
        this.applicationAddress = applicationAddress;
    }

    public Collection<Node> collected() {
        return Arrays.asList(this);
    }

    public boolean hasMissingPart() {
        return this.id().hasNoId() || this.name().hasNoName() || this.operationalAddress().hasNoAddress() || this.applicationAddress().hasNoAddress();
    }

    public final Address applicationAddress() {
        return this.applicationAddress;
    }

    public final Address operationalAddress() {
        return this.operationalAddress;
    }

    public final Id id() {
        return this.id;
    }

    public final Name name() {
        return this.name;
    }

    public boolean isLeaderOver(Id nodeId) {
        return this.isValid() && this.id().greaterThan(nodeId);
    }

    public boolean isValid() {
        return !this.hasMissingPart();
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != Node.class) {
            return false;
        }
        Node node = (Node)other;
        return this.id.equals(node.id) && this.name.equals(node.name) && this.operationalAddress.equals(node.operationalAddress) && this.applicationAddress.equals(node.applicationAddress);
    }

    public int hashCode() {
        return 31 * (this.id.hashCode() + this.name.hashCode() + this.operationalAddress.hashCode() + this.applicationAddress.hashCode());
    }

    public String toString() {
        return "Node[" + this.id + "," + this.name + "," + this.operationalAddress + ", " + this.applicationAddress + "]";
    }

    public boolean greaterThan(Node other) {
        return this.id.greaterThan(other.id);
    }

    @Override
    public int compareTo(Node other) {
        return this.id.compareTo(other.id);
    }
}

