/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base;

import io.vproxy.base.prometheus.Counter;
import io.vproxy.base.prometheus.Gauge;
import io.vproxy.base.prometheus.Metric;
import io.vproxy.base.prometheus.Metrics;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.Utils;
import io.vproxy.base.util.coll.AppendableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class GlobalInspection {
    private static final GlobalInspection inst = new GlobalInspection();
    private final Map<String, String> extraLabels;
    private final Metrics metrics = new Metrics();
    private final Gauge directBufferBytes;
    private final Counter directBufferAllocateCount;
    private final Counter directBufferFreeCount;
    private final Counter directBufferFinalizeBytesTotal;
    private final Counter directBufferFinalizeCount;

    public static GlobalInspection getInstance() {
        return inst;
    }

    private GlobalInspection() {
        this.extraLabels = this.getExtraLabels();
        this.directBufferBytes = new Gauge("direct_memory_bytes_current", new AppendableMap<String, String>().append("type", "buffer").appendAll(this.extraLabels));
        this.metrics.add(this.directBufferBytes);
        this.directBufferAllocateCount = new Counter("direct_memory_allocate_count", new AppendableMap<String, String>().append("type", "buffer").appendAll(this.extraLabels));
        this.metrics.add(this.directBufferAllocateCount);
        this.directBufferFreeCount = new Counter("direct_memory_free_count", new AppendableMap<String, String>().append("type", "buffer").appendAll(this.extraLabels));
        this.metrics.add(this.directBufferFreeCount);
        this.directBufferFinalizeBytesTotal = new Counter("direct_memory_finalize_bytes_total", new AppendableMap<String, String>().append("type", "buffer").appendAll(this.extraLabels));
        this.metrics.add(this.directBufferFinalizeBytesTotal);
        this.directBufferFinalizeCount = new Counter("direct_memory_finalize_count", new AppendableMap<String, String>().append("type", "buffer").appendAll(this.extraLabels));
        this.metrics.add(this.directBufferFinalizeCount);
        this.metrics.registerHelpMessage("direct_memory_bytes_current", "Current allocated direct memory in bytes");
        this.metrics.registerHelpMessage("direct_memory_allocate_count", "Total count of how many times the direct memory is allocated");
        this.metrics.registerHelpMessage("direct_memory_free_count", "Total count of how many times the direct memory is freed");
        this.metrics.registerHelpMessage("direct_memory_finalize_bytes_total", "Total bytes for finalized direct memory");
        this.metrics.registerHelpMessage("direct_memory_finalize_count", "Total count of how many times the direct memory is finalized");
        this.metrics.registerHelpMessage("ssl_unwrap_task_count", "Total count of how many times ssl unwrap requires executing a task");
        this.metrics.registerHelpMessage("ssl_unwrap_task_time_millis_total", "Total time cost for tasks required by ssl unwrapping");
        this.metrics.registerHelpMessage("thread_number_current", "The number of current running threads");
    }

    private Map<String, String> getExtraLabels() {
        String[] splitArray;
        String labels = Utils.getSystemProperty("global_inspection_prometheus_labels");
        if (labels == null || labels.isBlank()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String split : splitArray = labels.split(",")) {
            if (split.isBlank()) continue;
            if (!split.contains("=")) {
                throw new IllegalArgumentException("invalid format, expecting k=v, but got " + split);
            }
            String key = split.substring(0, split.indexOf(61));
            String value = split.substring(split.indexOf(61) + 1);
            ret.put(key, value);
        }
        assert (Logger.lowLevelDebug("reading GlobalInspectionPrometheusLabels=" + ret));
        return Collections.unmodifiableMap(ret);
    }

    public <M extends Metric> M addMetric(String metric, Map<String, String> labels, BiFunction<String, Map<String, String>, M> constructor) {
        HashMap<String, String> allLabels = new HashMap<String, String>(labels.size() + this.extraLabels.size());
        allLabels.putAll(labels);
        allLabels.putAll(this.extraLabels);
        Metric m = (Metric)constructor.apply(metric, allLabels);
        this.metrics.add(m);
        return (M)m;
    }

    public void removeMetric(Metric m) {
        this.metrics.remove(m);
    }

    public void registerHelpMessage(String metric, String msg) {
        this.metrics.registerHelpMessage(metric, msg);
    }

    public void directBufferAllocate(int size) {
        this.directBufferAllocateCount.incr(1L);
        this.directBufferBytes.incr(size);
    }

    public void directBufferFree(int size) {
        this.directBufferFreeCount.incr(1L);
        this.directBufferBytes.decr(size);
    }

    public void directBufferFinalize(int size) {
        this.directBufferFinalizeCount.incr(1L);
        this.directBufferFinalizeBytesTotal.incr(size);
    }

    public String getPrometheusString() {
        return this.metrics.toString();
    }
}

