/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.dns.dnsserverlistgetter;

import io.vproxy.base.Config;
import io.vproxy.base.dns.DnsServerListGetter;
import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.callback.Callback;
import io.vproxy.vfd.IP;
import io.vproxy.vfd.IPPort;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GetDnsServerListFromConfigFile
implements DnsServerListGetter {
    private long fileNameServerUpdateTimestamp = 0L;
    private List<IPPort> lastRetrievedResult;

    @Override
    public void get(boolean firstRun, Callback<List<IPPort>, Throwable> cb) {
        File f = GetDnsServerListFromConfigFile.getNameServerFile();
        if (f == null) {
            if (this.fileNameServerUpdateTimestamp == -1L) {
                firstRun = false;
            } else {
                this.fileNameServerUpdateTimestamp = -1L;
                firstRun = true;
            }
            if (firstRun) {
                Logger.error(LogType.ALERT, "cannot find dns server list config file");
            }
            this.lastRetrievedResult = Collections.emptyList();
        } else {
            long lastUpdate = f.lastModified();
            if (this.fileNameServerUpdateTimestamp == lastUpdate) {
                if (this.lastRetrievedResult != null) {
                    cb.succeeded(this.lastRetrievedResult);
                    return;
                }
                firstRun = false;
            } else {
                firstRun = true;
            }
            this.lastRetrievedResult = GetDnsServerListFromConfigFile.getNameServersFromFile(f, firstRun);
            this.fileNameServerUpdateTimestamp = lastUpdate;
        }
        cb.succeeded(this.lastRetrievedResult);
    }

    private static File getNameServerFile() {
        File f = new File(Config.workingDirectoryFile("resolv.conf"));
        if (f.exists() && f.isFile()) {
            return f;
        }
        f = new File("/etc/resolv.conf");
        if (f.exists() && f.isFile()) {
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<IPPort> getNameServersFromFile(File f, boolean firstRun) {
        FileInputStream stream;
        try {
            stream = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            Logger.shouldNotHappen("still getting FileNotFoundException while the file existence is already checked: " + f, e);
            return Collections.emptyList();
        }
        if (firstRun) {
            Logger.alert("trying to get name servers from " + f.getAbsolutePath());
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(stream));
            ArrayList<IPPort> ret = new ArrayList<IPPort>();
            while (true) {
                String line;
                try {
                    line = br.readLine();
                    if (line == null) {
                        break;
                    }
                }
                catch (IOException e) {
                    Logger.shouldNotHappen("reading name server conf " + f + " got exception", e);
                    ArrayList<IPPort> arrayList = ret;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return arrayList;
                }
                if (line.contains("#")) {
                    line = line.substring(0, line.indexOf("#"));
                }
                if (!(line = line.trim()).startsWith("nameserver ")) continue;
                if (IP.isIpLiteral(line = line.substring("nameserver ".length()))) {
                    IPPort addr = new IPPort(IP.from(line), 53);
                    String ipName = addr.getAddress().formatToIPString();
                    if ((ipName.startsWith("127.") || ipName.equals("[::1]") || ipName.startsWith("[::ffff:7f") || ipName.startsWith("[::7f")) && !ipName.equals("127.0.0.53")) continue;
                    ret.add(addr);
                    continue;
                }
                if (!firstRun) continue;
                Logger.warn(LogType.INVALID_EXTERNAL_DATA, f + " contains invalid nameserver config: " + line);
            }
            ArrayList<IPPort> arrayList = ret;
            return arrayList;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

