/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.prometheus;

import io.vproxy.base.prometheus.Metric;
import io.vproxy.base.util.coll.ConcurrentHashSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Metrics {
    private final Set<Metric> metrics = new ConcurrentHashSet<Metric>();
    private final Map<String, String> helpMessages = new ConcurrentHashMap<String, String>();

    public void add(Metric metric) {
        this.metrics.add(metric);
    }

    public void remove(Metric metric) {
        this.metrics.remove(metric);
    }

    public void registerHelpMessage(String metric, String message) {
        this.helpMessages.put(metric, message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Metric> metrics = new ArrayList<Metric>(this.metrics);
        metrics.sort((a, b) -> {
            int ret = a.metric.compareTo(b.metric);
            if (ret == 0) {
                return (int)(a.index - b.index);
            }
            return ret;
        });
        String lastMetricName = null;
        for (Metric metric : metrics) {
            if (!metric.metric.equals(lastMetricName)) {
                if (this.helpMessages.containsKey(metric.metric)) {
                    sb.append("# HELP ").append(metric.metric).append(" ").append(this.helpMessages.get(metric.metric)).append("\n");
                }
                sb.append("# TYPE ").append(metric.metric).append(" ").append(metric.type()).append("\n");
            }
            lastMetricName = metric.metric;
            sb.append(metric.metric).append("{");
            boolean isFirst = true;
            for (String key : metric.labelKeys) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(",");
                }
                sb.append(key).append("=").append(metric.labels.get(key));
            }
            sb.append("}").append(" ").append(metric.value()).append("\n");
        }
        return sb.toString();
    }
}

