/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util;

import io.vproxy.base.util.ToByteArray;
import io.vproxy.base.util.Utils;
import io.vproxy.base.util.bytearray.AbstractByteArray;
import io.vproxy.base.util.bytearray.CompositeByteArray;
import io.vproxy.base.util.bytearray.OneByteArray;
import io.vproxy.base.util.bytearray.PersistByteArray;
import io.vproxy.base.util.bytearray.SimpleByteArray;
import io.vproxy.base.util.bytearray.SubByteArray;
import io.vproxy.base.util.bytearray.UnmodifiableByteArray;
import io.vproxy.base.util.nio.ByteArrayChannel;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public interface ByteArray
extends ToByteArray {
    public static ByteArray allocate(int len) {
        if (len == 0) {
            return AbstractByteArray.EMPTY;
        }
        if (len == 1) {
            return new OneByteArray();
        }
        return ByteArray.from(Utils.allocateByteArray(len));
    }

    public static ByteArray allocateInitZero(int len) {
        if (len == 0 || len == 1) {
            return ByteArray.allocate(len);
        }
        return ByteArray.from(Utils.allocateByteArrayInitZero(len));
    }

    public static ByteArray from(byte b) {
        return new OneByteArray(b);
    }

    public static ByteArray from(byte[] array) {
        return new SimpleByteArray(array);
    }

    public static ByteArray from(ByteBuffer buf) {
        int len = buf.limit() - buf.position();
        if (buf.hasArray()) {
            return ByteArray.from(buf.array()).sub(buf.position(), len);
        }
        byte[] array = Utils.allocateByteArray(len);
        buf.get(array);
        return ByteArray.from(array);
    }

    public static ByteArray from(int ... array) {
        byte[] bytes = Utils.allocateByteArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            bytes[i] = (byte)array[i];
        }
        return ByteArray.from(bytes);
    }

    public static ByteArray from(String str) {
        return ByteArray.from(str.getBytes());
    }

    public static ByteArray fromHexString(String str) throws IllegalArgumentException {
        return ByteArray.from(Utils.hexToBytes(str));
    }

    public static ByteArray fromBinString(String str) throws IllegalArgumentException {
        return ByteArray.from(Utils.binToBytes(str));
    }

    public byte get(int var1);

    public ByteArray set(int var1, byte var2);

    public int length();

    default public ByteArray sub(int fromInclusive, int len) {
        return SubByteArray.sub(this, fromInclusive, len);
    }

    default public ByteArray concat(ByteArray array) {
        return new CompositeByteArray(this, array);
    }

    @Override
    default public ByteArray toByteArray() {
        return this;
    }

    default public byte[] toJavaArray() {
        return this.toNewJavaArray();
    }

    default public byte[] toNewJavaArray() {
        int len = this.length();
        byte[] array = Utils.allocateByteArray(len);
        this.toNewJavaArray(array, 0);
        return array;
    }

    public void toNewJavaArray(byte[] var1, int var2);

    default public ByteArray arrange() {
        return new SimpleByteArray(this.toNewJavaArray());
    }

    default public ByteArray copy() {
        return ByteArray.from(this.toNewJavaArray());
    }

    default public ByteArray unmodifiable() {
        return new UnmodifiableByteArray(this);
    }

    default public ByteArray persist() {
        return new PersistByteArray(this);
    }

    default public ByteArrayChannel toFullChannel() {
        return ByteArrayChannel.fromFull(this);
    }

    default public int uint24(int offset) {
        return this.uint8(offset) << 16 | this.uint8(offset + 1) << 8 | this.uint8(offset + 2);
    }

    default public int uint24ReverseNetworkByteOrder(int offset) {
        return this.uint8(offset + 2) << 16 | this.uint8(offset + 1) << 8 | this.uint8(offset);
    }

    default public long int64(int offset) {
        return this.uint8long(offset) << 56 | this.uint8long(offset + 1) << 48 | this.uint8long(offset + 2) << 40 | this.uint8long(offset + 3) << 32 | this.uint8long(offset + 4) << 24 | this.uint8long(offset + 5) << 16 | this.uint8long(offset + 6) << 8 | this.uint8long(offset + 7);
    }

    default public long int64ReverseNetworkByteOrder(int offset) {
        return this.uint8long(offset + 7) << 56 | this.uint8long(offset + 6) << 48 | this.uint8long(offset + 5) << 40 | this.uint8long(offset + 4) << 32 | this.uint8long(offset + 3) << 24 | this.uint8long(offset + 2) << 16 | this.uint8long(offset + 1) << 8 | this.uint8long(offset);
    }

    default public int int32(int offset) {
        return this.uint8(offset) << 24 | this.uint8(offset + 1) << 16 | this.uint8(offset + 2) << 8 | this.uint8(offset + 3);
    }

    default public int int32ReverseNetworkByteOrder(int offset) {
        return this.uint8(offset + 3) << 24 | this.uint8(offset + 2) << 16 | this.uint8(offset + 1) << 8 | this.uint8(offset);
    }

    default public long uint32(int offset) {
        return (long)this.uint8(offset) << 24 | (long)this.uint8(offset + 1) << 16 | (long)this.uint8(offset + 2) << 8 | (long)this.uint8(offset + 3);
    }

    default public long uint32ReverseNetworkByteOrder(int offset) {
        return (long)this.uint8(offset + 3) << 24 | (long)this.uint8(offset + 2) << 16 | (long)this.uint8(offset + 1) << 8 | (long)this.uint8(offset);
    }

    default public int uint16(int offset) {
        return this.uint8(offset) << 8 | this.uint8(offset + 1);
    }

    default public int uint16ReverseNetworkByteOrder(int offset) {
        return this.uint8(offset + 1) << 8 | this.uint8(offset);
    }

    default public int uint8(int offset) {
        return this.get(offset) & 0xFF;
    }

    default public long uint8long(int offset) {
        return (long)this.get(offset) & 0xFFL;
    }

    default public ByteArray int24(int offset, int val) {
        this.set(offset, (byte)(val >> 16 & 0xFF));
        this.set(offset + 1, (byte)(val >> 8 & 0xFF));
        this.set(offset + 2, (byte)(val & 0xFF));
        return this;
    }

    default public ByteArray int24ReverseNetworkByteOrder(int offset, int val) {
        this.set(offset, (byte)(val & 0xFF));
        this.set(offset + 1, (byte)(val >> 8 & 0xFF));
        this.set(offset + 2, (byte)(val >> 16 & 0xFF));
        return this;
    }

    default public ByteArray int16(int offset, int val) {
        this.set(offset, (byte)(val >> 8 & 0xFF));
        this.set(offset + 1, (byte)(val & 0xFF));
        return this;
    }

    default public ByteArray int16ReverseNetworkByteOrder(int offset, int val) {
        this.set(offset, (byte)(val & 0xFF));
        this.set(offset + 1, (byte)(val >> 8 & 0xFF));
        return this;
    }

    default public ByteArray int32(int offset, int val) {
        this.set(offset, (byte)(val >> 24 & 0xFF));
        this.set(offset + 1, (byte)(val >> 16 & 0xFF));
        this.set(offset + 2, (byte)(val >> 8 & 0xFF));
        this.set(offset + 3, (byte)(val & 0xFF));
        return this;
    }

    default public ByteArray int32ReverseNetworkByteOrder(int offset, int val) {
        this.set(offset, (byte)(val & 0xFF));
        this.set(offset + 1, (byte)(val >> 8 & 0xFF));
        this.set(offset + 2, (byte)(val >> 16 & 0xFF));
        this.set(offset + 3, (byte)(val >> 24 & 0xFF));
        return this;
    }

    default public ByteArray int64(int offset, long val) {
        this.set(offset, (byte)(val >> 56 & 0xFFL));
        this.set(offset + 1, (byte)(val >> 48 & 0xFFL));
        this.set(offset + 2, (byte)(val >> 40 & 0xFFL));
        this.set(offset + 3, (byte)(val >> 32 & 0xFFL));
        this.set(offset + 4, (byte)(val >> 24 & 0xFFL));
        this.set(offset + 5, (byte)(val >> 16 & 0xFFL));
        this.set(offset + 6, (byte)(val >> 8 & 0xFFL));
        this.set(offset + 7, (byte)(val & 0xFFL));
        return this;
    }

    default public ByteArray int64ReverseNetworkByteOrder(int offset, long val) {
        this.set(offset, (byte)(val & 0xFFL));
        this.set(offset + 1, (byte)(val >> 8 & 0xFFL));
        this.set(offset + 2, (byte)(val >> 16 & 0xFFL));
        this.set(offset + 3, (byte)(val >> 24 & 0xFFL));
        this.set(offset + 4, (byte)(val >> 32 & 0xFFL));
        this.set(offset + 5, (byte)(val >> 40 & 0xFFL));
        this.set(offset + 6, (byte)(val >> 48 & 0xFFL));
        this.set(offset + 7, (byte)(val >> 56 & 0xFFL));
        return this;
    }

    public void byteBufferPut(ByteBuffer var1, int var2, int var3);

    public void byteBufferGet(ByteBuffer var1, int var2, int var3);

    default public void copyInto(ByteArray dst, int dstOff, int srcOff, int srcLen) {
        for (int i = 0; i < srcLen; ++i) {
            dst.set(dstOff + i, this.get(srcOff + i));
        }
    }

    default public String toHexString() {
        return Utils.bytesToHex(this.toJavaArray());
    }

    default public String hexDump() {
        return this.hexDump(16);
    }

    default public String hexDump(int bytesPerLine) {
        StringBuilder result = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        int size = this.length();
        for (int i = 0; i < size; i += bytesPerLine) {
            int j;
            sb.delete(0, sb.length());
            for (j = 0; j < bytesPerLine && i + j < size; ++j) {
                int n = this.get(i + j) & 0xFF;
                Object s = Integer.toString(n, 16);
                if (((String)s).length() == 1) {
                    s = "0" + (String)s;
                }
                result.append((String)s);
                result.append(" ");
                if (n >= 33 && n <= 126) {
                    sb.append((char)n);
                    continue;
                }
                sb.append(".");
            }
            result.append(" ".repeat(7));
            if (bytesPerLine > j) {
                result.append(" ".repeat((bytesPerLine - j) * 3));
            }
            result.append((CharSequence)sb).append("\n");
        }
        return result.toString();
    }

    default public byte[] toGZipJavaByteArray() {
        byte[] dataToCompress = this.toJavaArray();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        return Utils.gzipCompress(out, dataToCompress);
    }

    private byte upperByte(byte b) {
        return 97 <= b && b <= 122 ? (byte)(b - 32) : b;
    }

    default public ByteArray trim() {
        int end;
        int start;
        int len = this.length();
        for (start = 0; start < len && Character.isWhitespace((char)this.get(start)); ++start) {
        }
        if (len == start) {
            return AbstractByteArray.EMPTY;
        }
        for (end = this.length() - 1; end >= 0 && Character.isWhitespace((char)this.get(end)); --end) {
        }
        if (start == end) {
            return AbstractByteArray.EMPTY;
        }
        return this.sub(start, end - start + 1);
    }

    default public boolean equalsIgnoreCase(ByteArray other) {
        if (this.length() != other.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.upperByte(this.get(i)) == this.upperByte(other.get(i))) continue;
            return false;
        }
        return true;
    }

    default public boolean equalsIgnoreCaseAfterTrim(ByteArray other) {
        return this.trim().equalsIgnoreCase(other.trim());
    }
}

