/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util;

import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Utils;
import io.vproxy.base.util.log.LogDispatcher;
import io.vproxy.base.util.log.LogLevel;
import io.vproxy.base.util.log.LogRecord;
import io.vproxy.base.util.log.STDOutLogHandler;
import java.util.Set;
import java.util.regex.Pattern;

public class Logger {
    public static final boolean stackTraceOn;
    public static final boolean lowLevelDebugOn;
    public static final boolean lowLevelNetDebugOn;
    public static final LogDispatcher logDispatcher;
    public static final STDOutLogHandler stdoutLogHandler;
    private static final Pattern loggerPattern1;
    private static final Set<String> ADD_DEBUG_INFO_CLASS_PREFIX;

    public static boolean debugOn() {
        return Utils.assertOn() && (lowLevelDebugOn || lowLevelNetDebugOn);
    }

    private Logger() {
    }

    private static StackTraceElement getFirstElementOutOfLoggerLib() {
        StackTraceElement[] arr = Thread.currentThread().getStackTrace();
        boolean intoLoggerLib = false;
        for (StackTraceElement e : arr) {
            String cls = e.getClassName();
            if (loggerPattern1.matcher(cls).matches() || cls.equals("io.vproxy.adaptor.vertx.VProxyLogDelegate") || cls.equals("io.vertx.core.impl.logging.LoggerAdapter")) {
                intoLoggerLib = true;
                continue;
            }
            if (!intoLoggerLib) continue;
            return e;
        }
        return arr[arr.length - 1];
    }

    public static boolean lowLevelDebug(String msg) {
        if (!lowLevelDebugOn) {
            return true;
        }
        return Logger.debugLog(msg);
    }

    public static boolean lowLevelNetDebug(String msg) {
        if (!lowLevelNetDebugOn || !lowLevelDebugOn) {
            return true;
        }
        return Logger.debugLog(msg);
    }

    private static boolean debugLog(String msg) {
        String threadName = Thread.currentThread().getName();
        StackTraceElement elem = Logger.getFirstElementOutOfLoggerLib();
        LogRecord record = new LogRecord(threadName, elem, LogLevel.DEBUG, null, Logger.currentTimeMillis(), Logger.getDebugInfo(elem) + msg, null);
        logDispatcher.publish(record);
        return true;
    }

    private static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    private static String getDebugInfo(StackTraceElement elem) {
        String debugInfo;
        String clsName = elem.getClassName();
        boolean addDebugInfo = false;
        for (String cls : ADD_DEBUG_INFO_CLASS_PREFIX) {
            if (!clsName.startsWith(cls)) continue;
            addDebugInfo = true;
            break;
        }
        if (addDebugInfo && (debugInfo = null) != null && !debugInfo.isBlank()) {
            return debugInfo + " - ";
        }
        return "";
    }

    private static void privateErr(LogLevel level, LogType type, String err, Throwable t) {
        String threadName = Thread.currentThread().getName();
        StackTraceElement elem = Logger.getFirstElementOutOfLoggerLib();
        LogRecord record = new LogRecord(threadName, elem, level, type, Logger.currentTimeMillis(), err, t);
        logDispatcher.publish(record);
    }

    public static void fatal(LogType logType, String err) {
        Logger.privateErr(LogLevel.FATAL, logType, err, null);
    }

    public static void fatal(LogType logType, String err, Throwable ex) {
        Logger.privateErr(LogLevel.FATAL, logType, err, ex);
    }

    public static void error(LogType logType, String err) {
        Logger.privateErr(LogLevel.ERROR, logType, err, null);
    }

    public static void error(LogType logType, String err, Throwable ex) {
        Logger.privateErr(LogLevel.ERROR, logType, err, ex);
    }

    public static void warn(LogType logType, String msg) {
        LogRecord record = new LogRecord(null, null, LogLevel.WARN, logType, Logger.currentTimeMillis(), msg, null);
        logDispatcher.publish(record);
    }

    public static void warn(LogType logType, String err, Throwable t) {
        LogRecord record = new LogRecord(null, null, LogLevel.WARN, logType, Logger.currentTimeMillis(), err, t);
        logDispatcher.publish(record);
    }

    public static void info(LogType logType, String msg) {
        LogRecord record = new LogRecord(null, null, LogLevel.INFO, logType, Logger.currentTimeMillis(), msg, null);
        logDispatcher.publish(record);
    }

    public static void trace(LogType logType, String msg) {
        LogRecord record = new LogRecord(null, null, LogLevel.TRACE, logType, Logger.currentTimeMillis(), msg, null);
        logDispatcher.publish(record);
    }

    public static void shouldNotHappen(String msg) {
        Logger.fatal(LogType.UNEXPECTED, "should not happen - " + msg);
    }

    public static void alert(String msg) {
        Logger.info(LogType.ALERT, msg);
    }

    public static void access(String msg) {
        Logger.info(LogType.ACCESS, msg);
    }

    public static void shouldNotHappen(String msg, Throwable err) {
        Logger.fatal(LogType.UNEXPECTED, "should not happen - " + msg, err);
    }

    public static boolean printStackTrace(Throwable t) {
        t.printStackTrace(System.out);
        return true;
    }

    public static boolean lowLevelNetDebugPrintBytes(byte[] array) {
        if (lowLevelNetDebugOn) {
            Logger.printBytes(array);
        }
        return true;
    }

    public static boolean lowLevelNetDebugPrintBytes(byte[] array, int off, int end) {
        if (lowLevelNetDebugOn) {
            Logger.printBytes(array, off, end);
        }
        return true;
    }

    public static void printBytes(byte[] array) {
        Logger.printBytes(array, 0, array.length);
    }

    public static void printBytes(byte[] array, int off, int end) {
        int i;
        byte[] tmp = Utils.allocateByteArray(end - off);
        System.arraycopy(array, off, tmp, 0, end - off);
        array = tmp;
        int bytesPerLine = 36;
        int lastLine = array.length % 36;
        if (lastLine == 0) {
            lastLine = 36;
        }
        int lines = array.length / 36 + (lastLine != 36 ? 1 : 0);
        byte[][] linesArray = new byte[lines][];
        for (i = 0; i < linesArray.length - 1; ++i) {
            linesArray[i] = Utils.allocateByteArray(36);
        }
        linesArray[linesArray.length - 1] = Utils.allocateByteArray(lastLine);
        for (i = 0; i < array.length; ++i) {
            int idx0 = i / 36;
            int idx1 = i % 36;
            linesArray[idx0][idx1] = array[i];
        }
        for (int idx = 0; idx < linesArray.length; ++idx) {
            byte[] line = linesArray[idx];
            System.out.print(Utils.bytesToHex(line));
            System.out.print("    ");
            if (idx == linesArray.length - 1) {
                for (int i2 = 0; i2 < 2 * (36 - lastLine); ++i2) {
                    System.out.print(" ");
                }
            }
            char[] cs = new char[line.length];
            for (int i3 = 0; i3 < line.length; ++i3) {
                int b = line[i3];
                if (b < 0) {
                    b += 256;
                }
                cs[i3] = b < 32 || b > 126 ? 46 : (char)b;
            }
            System.out.println(new String(cs));
        }
    }

    public static char toPrintableChar(byte bb) {
        int b = bb;
        if (b < 0) {
            b += 256;
        }
        if (b < 32 || b > 126) {
            return '.';
        }
        return (char)b;
    }

    static {
        String stackTrace;
        logDispatcher = new LogDispatcher();
        String debug = Utils.getSystemProperty("debug");
        lowLevelDebugOn = !"off".equals(debug);
        debug = System.getProperty("javax.net.debug");
        boolean bl = lowLevelNetDebugOn = "all".equals(debug) || "vproxy".equals(debug);
        stackTraceOn = lowLevelDebugOn && Utils.assertOn() ? true : !"off".equals(stackTrace = Utils.getSystemProperty("stacktrace", "off"));
        stdoutLogHandler = new STDOutLogHandler(stackTraceOn);
        logDispatcher.addLogHandler(stdoutLogHandler);
        loggerPattern1 = Pattern.compile(".*Logger\\b.*");
        ADD_DEBUG_INFO_CLASS_PREFIX = Set.of("io.vproxy.vswitch.");
    }
}

