/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util;

import io.vproxy.base.util.OS;
import io.vproxy.base.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;

public class MainUtils {
    private MainUtils() {
    }

    public static String[] checkFlagDeployInArguments(String[] args) {
        ArrayList<String> returnArgs = new ArrayList<String>(args.length);
        for (String arg : args) {
            if (!arg.startsWith("-D")) {
                returnArgs.add(arg);
                continue;
            }
            String kv = arg.substring("-D".length());
            if (!kv.contains("=")) {
                returnArgs.add(arg);
                continue;
            }
            String key = kv.substring(0, kv.indexOf("="));
            String value = kv.substring(kv.indexOf("=") + 1);
            if (Utils.getSystemProperty(key) != null) {
                throw new IllegalArgumentException("Cannot set -D" + key + " both in system properties and in program arguments");
            }
            System.setProperty(key, value);
        }
        String deploy = Utils.getSystemProperty("deploy");
        String dhcpGetDnsListNics = Utils.getSystemProperty("dhcp_get_dns_list_nics");
        if (dhcpGetDnsListNics == null) {
            if (deploy != null && OS.isWindows() && Arrays.asList("WebSocksProxyAgent", "WebSocksAgent", "wsagent").contains(deploy)) {
                dhcpGetDnsListNics = "all";
            }
            if (dhcpGetDnsListNics != null) {
                System.setProperty("vproxy.DhcpGetDnsListNics", dhcpGetDnsListNics);
            }
        }
        return returnArgs.toArray(new String[returnArgs.size()]);
    }
}

