/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.NetworkV4;
import io.vproxy.base.util.NetworkV6;
import io.vproxy.base.util.Utils;
import io.vproxy.vfd.IP;
import io.vproxy.vfd.IPv4;
import io.vproxy.vfd.IPv6;
import java.util.Objects;

public abstract class Network {
    protected final IP ip;
    protected final ByteArray mask;
    protected final int maskNumber;

    protected Network(IP ip, ByteArray mask) {
        this.ip = ip;
        this.mask = mask;
        this.maskNumber = Network.maskInt(mask.toJavaArray());
    }

    public static Network from(byte[] ip, byte[] mask) {
        return Network.from(IP.from(ip), ByteArray.from(mask));
    }

    public static Network from(IP ip, ByteArray mask) {
        if (ip instanceof IPv4) {
            return new NetworkV4((IPv4)ip, mask);
        }
        if (ip instanceof IPv6) {
            return new NetworkV6((IPv6)ip, mask);
        }
        throw new IllegalArgumentException("ip is not ipv4 nor ipv6: " + ip);
    }

    public static Network from(String net) {
        if (!Network.validNetworkStr(net)) {
            throw new IllegalArgumentException("not valid network " + net);
        }
        String ip = net.substring(0, net.lastIndexOf("/"));
        int mask = Integer.parseInt(net.substring(net.indexOf("/") + 1));
        return Network.from(IP.from(ip), ByteArray.from(Network.parseMask(mask)));
    }

    public abstract boolean contains(IP var1);

    public boolean contains(Network that) {
        if (!this.contains(that.ip)) {
            return false;
        }
        return this.getMask() < that.getMask();
    }

    public IP getIp() {
        return this.ip;
    }

    public int getMask() {
        return this.maskNumber;
    }

    public byte[] getRawIpBytes() {
        return this.ip.bytes.toJavaArray();
    }

    public byte[] getRawMaskBytes() {
        return this.mask.toJavaArray();
    }

    public ByteArray getRawMaskByteArray() {
        return this.mask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Network network = (Network)o;
        return Objects.equals(this.ip, network.ip) && Objects.equals(this.mask, network.mask);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.ip);
        result = 31 * result + Objects.hashCode(this.mask);
        return result;
    }

    public String toString() {
        return this.ip.formatToIPString() + "/" + this.getMask();
    }

    public static boolean validNetworkStr(String net) {
        byte[] maskBytes;
        int intMask;
        if (!net.contains("/")) {
            return false;
        }
        String[] arrs = net.split("/");
        if (arrs.length != 2) {
            return false;
        }
        try {
            intMask = Integer.parseInt(arrs[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        String nStr = arrs[0];
        byte[] nBytes = IP.parseIpString(nStr);
        if (nBytes == null) {
            return false;
        }
        try {
            maskBytes = Network.parseMask(intMask);
        }
        catch (Exception e) {
            return false;
        }
        return Network.validNetwork(nBytes, maskBytes);
    }

    public static byte[] parseMask(int mask) {
        if (mask > 128) {
            throw new IllegalArgumentException("unknown mask " + mask);
        }
        if (mask > 32) {
            return Network.getMask(Utils.allocateByteArrayInitZero(16), mask);
        }
        return Network.getMask(Utils.allocateByteArrayInitZero(4), mask);
    }

    private static byte[] getMask(byte[] masks, int mask) {
        for (int i = 0; i < masks.length; ++i) {
            masks[i] = Utils.genPrefixByte(mask);
            mask -= 8;
        }
        return masks;
    }

    public static int maskInt(byte[] mask) {
        int cnt;
        int m = 0;
        for (int i = mask.length - 1; i >= 0 && (cnt = Utils.zeros(mask[i])) != 0; --i) {
            m += cnt;
        }
        return mask.length * 8 - m;
    }

    public static Network eraseToNetwork(IP ip, int mask) {
        byte[] maskbytes;
        byte[] ipbytes;
        if (ip instanceof IPv4) {
            ipbytes = ip.bytes.toNewJavaArray();
            maskbytes = new byte[4];
        } else {
            ipbytes = ip.bytes.toNewJavaArray();
            maskbytes = new byte[16];
        }
        Network.getMask(maskbytes, mask);
        Network.eraseToNetwork(ipbytes, maskbytes);
        return Network.from(ipbytes, maskbytes);
    }

    public static void eraseToNetwork(byte[] addr, byte[] mask) {
        int i;
        if (addr.length < mask.length) {
            throw new IllegalArgumentException();
        }
        for (i = 0; i < mask.length; ++i) {
            byte a = addr[i];
            byte m = mask[i];
            addr[i] = (byte)(a & m);
        }
        for (i = mask.length; i < addr.length; ++i) {
            addr[i] = 0;
        }
    }

    public static boolean validNetwork(byte[] addr, byte[] mask) {
        byte a;
        int i;
        if (addr.length < mask.length) {
            return false;
        }
        for (i = 0; i < mask.length; ++i) {
            a = addr[i];
            byte m = mask[i];
            if ((a & m) == a) continue;
            return false;
        }
        for (i = mask.length; i < addr.length; ++i) {
            a = addr[i];
            if (a == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean maskMatch(byte[] input, byte[] rule, byte[] mask) {
        if (input.length == rule.length && rule.length > mask.length) {
            for (int i = 0; i < mask.length; ++i) {
                byte inputB = input[i];
                byte maskB = mask[i];
                byte ruleB = rule[i];
                if ((inputB & maskB) == ruleB) continue;
                return false;
            }
            return true;
        }
        if (input.length < rule.length && rule.length > mask.length) {
            return false;
        }
        if (input.length < rule.length && rule.length == mask.length) {
            int lastLowIdx = rule.length - input.length - 1;
            int secondLastLowIdx = lastLowIdx - 1;
            for (int i = 0; i < input.length; ++i) {
                byte inputB = input[i];
                byte maskB = mask[i + rule.length - input.length];
                byte ruleB = rule[i + rule.length - input.length];
                if ((inputB & maskB) == ruleB) continue;
                return false;
            }
            return Utils.lowBitsV6V4(rule, lastLowIdx, secondLastLowIdx);
        }
        int minLen = input.length;
        if (rule.length < minLen) {
            minLen = rule.length;
        }
        if (mask.length < minLen) {
            minLen = mask.length;
        }
        for (int i = 0; i < minLen; ++i) {
            byte inputB = input[input.length - i - 1];
            byte maskB = mask[mask.length - i - 1];
            byte ruleB = rule[rule.length - i - 1];
            if ((inputB & maskB) == ruleB) continue;
            return false;
        }
        if (input.length > rule.length) {
            int lastLowIdx = input.length - rule.length - 1;
            int secondLastLowIdx = lastLowIdx - 1;
            return Utils.lowBitsV6V4(input, lastLowIdx, secondLastLowIdx);
        }
        return true;
    }
}

