/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Network;
import io.vproxy.base.util.Utils;
import io.vproxy.vfd.IP;
import io.vproxy.vfd.IPv4;
import io.vproxy.vfd.IPv6;

public class NetworkV6
extends Network {
    protected final int a;
    protected final int b;
    protected final int c;
    protected final int d;

    protected NetworkV6(IPv6 ip, ByteArray mask) {
        super(ip, mask);
        this.a = ip.getIPv6Value0();
        this.b = ip.getIPv6Value1();
        this.c = ip.getIPv6Value2();
        this.d = ip.getIPv6Value3();
    }

    @Override
    public boolean contains(IP address) {
        int mask = this.getMask();
        if (address instanceof IPv4) {
            if (this.a == 0 && this.b == 0 && (this.c == 65535 || this.c == 0)) {
                if (mask < 96) {
                    return true;
                }
                return (((IPv4)address).getIPv4Value() & Utils.maskNumberToInt(mask - 96)) == this.d;
            }
            return false;
        }
        if (address instanceof IPv6) {
            int m = ((IPv6)address).getIPv6Value0();
            int n = ((IPv6)address).getIPv6Value1();
            int o = ((IPv6)address).getIPv6Value2();
            int p = ((IPv6)address).getIPv6Value3();
            if (mask >= 128) {
                return this.a == m && this.b == n && this.c == o && this.d == p;
            }
            if (mask > 96) {
                return this.a == m && this.b == n && this.c == o && (p & Utils.maskNumberToInt(mask - 96)) == this.d;
            }
            if (mask > 64) {
                return this.a == m && this.b == n && (o & Utils.maskNumberToInt(mask - 64)) == this.c;
            }
            if (mask > 32) {
                return this.a == m && (n & Utils.maskNumberToInt(mask - 32)) == this.b;
            }
            return (m & Utils.maskNumberToInt(mask)) == this.a;
        }
        return false;
    }
}

