/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util;

import io.vproxy.base.util.Network;
import io.vproxy.base.util.NetworkV4;
import io.vproxy.base.util.NetworkV6;
import io.vproxy.base.util.functional.ConsumerEx;
import io.vproxy.vfd.IP;
import io.vproxy.vfd.IPv4;
import io.vproxy.vfd.IPv6;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class Networks<R extends Rule> {
    private final List<V4RulesGroupedByMask> v4Rules = new ArrayList<V4RulesGroupedByMask>(32);
    private final List<V6RulesGroupedByMask> v6Rules = new ArrayList<V6RulesGroupedByMask>(128);

    private R cast(Rule r) {
        return (R)r;
    }

    public R lookup(Network net) {
        if (net instanceof NetworkV4) {
            int mask = net.getMask();
            for (V4RulesGroupedByMask rules : this.v4Rules) {
                if (rules.mask != mask) continue;
                return this.cast(rules.rules.get(((IPv4)net.getIp()).getIPv4Value()));
            }
            return null;
        }
        if (net instanceof NetworkV6) {
            int mask = net.getMask();
            for (V6RulesGroupedByMask rules : this.v6Rules) {
                if (rules.mask != mask) continue;
                return this.cast(rules.rules.get(((IPv6)net.getIp()).getIPv6Values()));
            }
            return null;
        }
        throw new IllegalArgumentException("unexpected network " + net);
    }

    public R lookup(IP ip) {
        if (ip instanceof IPv4) {
            IPv6 v6;
            R res = this.cast(this.lookupV4((IPv4)ip));
            if (res == null && (v6 = ip.to6()) != null) {
                res = this.cast(this.lookupV6(v6));
            }
            return res;
        }
        if (ip instanceof IPv6) {
            IPv4 v4;
            R res = this.cast(this.lookupV6((IPv6)ip));
            if (res == null && (v4 = ip.to4()) != null) {
                res = this.cast(this.lookupV4(v4));
            }
            return res;
        }
        throw new IllegalArgumentException("unexpected ip " + ip);
    }

    private Rule lookupV4(IPv4 ip) {
        int size = this.v4Rules.size();
        for (int i = 0; i < size; ++i) {
            V4RulesGroupedByMask rules = this.v4Rules.get(i);
            int v4 = ip.maskValue(rules.mask);
            Rule rule = rules.rules.get(v4);
            if (rule == null) continue;
            return rule;
        }
        return null;
    }

    private Rule lookupV6(IPv6 ip) {
        int size = this.v6Rules.size();
        for (int i = 0; i < size; ++i) {
            V6RulesGroupedByMask rules = this.v6Rules.get(i);
            IPv6.Values v6 = ip.maskValues(rules.mask);
            Rule rule = rules.rules.get(v6);
            if (rule == null) continue;
            return rule;
        }
        return null;
    }

    public R add(Network net, R rule) {
        if (net instanceof NetworkV4) {
            return this.cast(this.addV4(net, rule));
        }
        if (net instanceof NetworkV6) {
            return this.cast(this.addV6(net, rule));
        }
        throw new IllegalArgumentException("unexpected network " + net);
    }

    private Rule addV4(Network net, R rule) {
        int mask = net.getMask();
        V4RulesGroupedByMask group = null;
        for (int i = 0; i < this.v4Rules.size(); ++i) {
            V4RulesGroupedByMask rules = this.v4Rules.get(i);
            if (rules.mask > mask) continue;
            if (rules.mask == mask) {
                group = rules;
                break;
            }
            group = new V4RulesGroupedByMask(mask);
            this.v4Rules.add(i, group);
            break;
        }
        if (group == null) {
            group = new V4RulesGroupedByMask(mask);
            this.v4Rules.add(group);
        }
        return group.rules.put(((IPv4)net.getIp()).getIPv4Value(), (Rule)rule);
    }

    private Rule addV6(Network net, R rule) {
        int mask = net.getMask();
        V6RulesGroupedByMask group = null;
        for (int i = 0; i < this.v6Rules.size(); ++i) {
            V6RulesGroupedByMask rules = this.v6Rules.get(i);
            if (rules.mask > mask) continue;
            if (rules.mask == mask) {
                group = rules;
                break;
            }
            group = new V6RulesGroupedByMask(mask);
            this.v6Rules.add(i, group);
            break;
        }
        if (group == null) {
            group = new V6RulesGroupedByMask(mask);
            this.v6Rules.add(group);
        }
        return group.rules.put(((IPv6)net.getIp()).getIPv6Values(), (Rule)rule);
    }

    public R remove(Network net) {
        if (net instanceof NetworkV4) {
            return this.cast(this.removeV4(net));
        }
        if (net instanceof NetworkV6) {
            return this.cast(this.removeV6(net));
        }
        throw new IllegalArgumentException("unexpected network " + net);
    }

    private Rule removeV4(Network net) {
        int mask = net.getMask();
        for (int i = 0; i < this.v4Rules.size(); ++i) {
            V4RulesGroupedByMask rules = this.v4Rules.get(i);
            if (rules.mask < mask) break;
            if (rules.mask > mask) continue;
            Rule ret = rules.rules.remove(((IPv4)net.getIp()).getIPv4Value());
            if (rules.rules.isEmpty()) {
                this.v4Rules.remove(i);
            }
            return ret;
        }
        return null;
    }

    private Rule removeV6(Network net) {
        int mask = net.getMask();
        for (int i = 0; i < this.v6Rules.size(); ++i) {
            V6RulesGroupedByMask rules = this.v6Rules.get(i);
            if (rules.mask < mask) break;
            if (rules.mask > mask) continue;
            Rule ret = rules.rules.remove(((IPv6)net.getIp()).getIPv6Values());
            if (rules.rules.isEmpty()) {
                this.v6Rules.remove(i);
            }
            return ret;
        }
        return null;
    }

    public <EX extends Throwable> void forEach(ConsumerEx<R, EX> f) throws EX {
        for (V4RulesGroupedByMask v4RulesGroupedByMask : this.v4Rules) {
            for (Rule rule : v4RulesGroupedByMask.rules.values()) {
                f.accept(this.cast(rule));
            }
        }
        for (V6RulesGroupedByMask v6RulesGroupedByMask : this.v6Rules) {
            for (Rule rule : v6RulesGroupedByMask.rules.values()) {
                f.accept(this.cast(rule));
            }
        }
    }

    public R removeBy(Predicate<R> f) {
        Rule rule;
        Iterator<Rule> iterator;
        Object rules;
        Iterator<Object> iter = this.v4Rules.iterator();
        while (iter.hasNext()) {
            rules = iter.next();
            iterator = ((V4RulesGroupedByMask)rules).rules.values().iterator();
            while (iterator.hasNext()) {
                rule = iterator.next();
                if (!f.test(this.cast(rule))) continue;
                iterator.remove();
                if (((V4RulesGroupedByMask)rules).rules.isEmpty()) {
                    iter.remove();
                }
                return this.cast(rule);
            }
        }
        iter = this.v6Rules.iterator();
        while (iter.hasNext()) {
            rules = (V6RulesGroupedByMask)iter.next();
            iterator = ((V6RulesGroupedByMask)rules).rules.values().iterator();
            while (iterator.hasNext()) {
                rule = iterator.next();
                if (!f.test(this.cast(rule))) continue;
                iterator.remove();
                if (((V6RulesGroupedByMask)rules).rules.isEmpty()) {
                    iter.remove();
                }
                return this.cast(rule);
            }
        }
        return null;
    }

    public List<R> getRules() {
        ArrayList res = new ArrayList();
        this.forEach(res::add);
        return res;
    }

    private static final class V6RulesGroupedByMask {
        final int mask;
        final Map<IPv6.Values, Rule> rules = new HashMap<IPv6.Values, Rule>();

        private V6RulesGroupedByMask(int mask) {
            this.mask = mask;
        }
    }

    private static final class V4RulesGroupedByMask {
        final int mask;
        final Map<Integer, Rule> rules = new HashMap<Integer, Rule>();

        private V4RulesGroupedByMask(int mask) {
            this.mask = mask;
        }

        public String toString() {
            return "{mask=" + this.mask + ", rules=" + this.rules + "}";
        }
    }

    public static interface Rule {
    }
}

