/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util;

public class OS {
    private static final String osname = System.getProperty("os.name", "");
    private static final String osversion = System.getProperty("os.version", "");
    private static final boolean osWin;
    private static final boolean osMac;
    private static final boolean osLinux;
    private static final String arch;
    private static final int linuxMajorVersion;
    private static final int linuxMinorVersion;

    private OS() {
    }

    public static String name() {
        return osname;
    }

    public static String version() {
        return osversion;
    }

    public static int major() {
        return linuxMajorVersion;
    }

    public static int minor() {
        return linuxMinorVersion;
    }

    public static boolean isWindows() {
        return osWin;
    }

    public static boolean isMac() {
        return osMac;
    }

    public static boolean isLinux() {
        return osLinux;
    }

    public static String arch() {
        return arch;
    }

    static {
        String os = osname.toLowerCase();
        osLinux = os.contains("linux");
        osMac = os.contains("mac");
        osWin = os.contains("windows");
        String arch0 = System.getProperty("os.arch", "x86_64");
        if (arch0.equals("amd64")) {
            arch0 = "x86_64";
        } else if (arch0.equals("arm64")) {
            arch0 = "aarch64";
        }
        arch = arch0;
        int major = -1;
        int minor = -1;
        if (osLinux) {
            String[] split = osversion.split("\\.");
            if (split.length >= 2) {
                try {
                    major = Integer.parseInt(split[0]);
                    minor = Integer.parseInt(split[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (minor == -1) {
                major = -1;
            }
        }
        linuxMajorVersion = major;
        linuxMinorVersion = minor;
    }
}

