/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util;

import io.vproxy.base.util.RingBufferETHandler;
import io.vproxy.base.util.Utils;
import io.vproxy.base.util.nio.ByteArrayChannel;
import io.vproxy.base.util.ringbuffer.SimpleRingBuffer;
import io.vproxy.vfd.ReadableByteStream;
import io.vproxy.vfd.WritableByteStream;
import java.io.IOException;
import java.util.Set;

public interface RingBuffer {
    public static final SimpleRingBuffer EMPTY_BUFFER = RingBuffer.allocate(0);

    public static SimpleRingBuffer allocateDirect(int cap) {
        return SimpleRingBuffer.allocateDirect(cap);
    }

    public static SimpleRingBuffer allocate(int cap) {
        return SimpleRingBuffer.allocate(cap);
    }

    default public int storeBytesFrom(ByteArrayChannel channel) {
        try {
            return this.storeBytesFrom((ReadableByteStream)channel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int storeBytesFrom(ReadableByteStream var1) throws IOException;

    default public int writeTo(ByteArrayChannel channel) {
        try {
            return this.writeTo((WritableByteStream)channel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    default public int writeTo(WritableByteStream channel) throws IOException {
        return this.writeTo(channel, Integer.MAX_VALUE);
    }

    public int writeTo(WritableByteStream var1, int var2) throws IOException;

    default public int writeTo(RingBuffer buffer, int maxBytesToWrite) {
        if (maxBytesToWrite < 0) {
            throw new IllegalArgumentException("input parameter maxBytesToWrite = " + maxBytesToWrite + " < 0");
        }
        int bufferFreeSpace = buffer.free();
        int len = Math.min(maxBytesToWrite, bufferFreeSpace);
        if (len == 0) {
            return 0;
        }
        ByteArrayChannel chnl = ByteArrayChannel.fromEmpty(Utils.allocateByteArray(len));
        int n = this.writeTo(chnl);
        buffer.storeBytesFrom(chnl);
        return n;
    }

    public int free();

    public int used();

    public int capacity();

    default public byte[] getBytes() {
        throw new UnsupportedOperationException();
    }

    public void addHandler(RingBufferETHandler var1);

    public void removeHandler(RingBufferETHandler var1);

    public Set<RingBufferETHandler> getHandlers();

    public void clean();

    public void clear();

    default public RingBuffer switchBuffer(RingBuffer buf) throws RejectSwitchException {
        return buf;
    }

    default public boolean isParentOf(RingBuffer buf) {
        return false;
    }

    public static boolean haveRelationBetween(RingBuffer a, RingBuffer b) {
        return a.isParentOf(b) || b.isParentOf(a);
    }

    public static class RejectSwitchException
    extends Exception {
        public RejectSwitchException(String msg) {
            super(msg);
        }
    }
}

