/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.base.util;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.OS;
import io.vproxy.base.util.callback.BlockCallback;
import io.vproxy.base.util.callback.Callback;
import io.vproxy.base.util.exception.AlreadyExistException;
import io.vproxy.base.util.exception.NotFoundException;
import io.vproxy.base.util.exception.XException;
import io.vproxy.base.util.net.Nic;
import io.vproxy.base.util.unsafe.JDKUnsafe;
import io.vproxy.vfd.MacAddress;
import io.vproxy.vpacket.Ipv4Packet;
import io.vproxy.vpacket.Ipv6Packet;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Utils {
    public static final List<String> RESET_MSG;
    public static final String BROKEN_PIPE_MSG = "Broken pipe";
    public static final String SSL_ENGINE_CLOSED_MSG = "SSLEngine closed";
    public static final String HOST_IS_DOWN_MSG = "Host is down";
    public static final String NO_ROUTE_TO_HOST_MSG = "No route to host";
    private static volatile int sync;
    private static final boolean assertOn;
    private static final Set<Class<?>> hideClassNameExceptions;
    private static final char[] HEX_ARRAY;
    private static final int UNINITIALIZED_BYTE_ARRAY_THRESHOLD = 512;
    private static final byte[] ZERO_LENGTH_BYTE_ARRAY;
    private static final int[] maskValues;

    private Utils() {
    }

    public static void syncCpuCacheAndMemory() {
        ++sync;
    }

    public static int positive(byte b) {
        if (b < 0) {
            return 256 + b;
        }
        return b;
    }

    public static int positive(short s) {
        if (s < 0) {
            return 32768 + s;
        }
        return s;
    }

    public static String homedir() {
        return System.getProperty("user.home");
    }

    public static String filename(String s) {
        if (((String)s).startsWith("~")) {
            s = Utils.homedir() + ((String)s).substring(1);
        }
        return s;
    }

    public static String homefile(String s) {
        return Utils.homedir() + File.separator + s;
    }

    private static String addTo(int len, String s) {
        if (s.length() >= len) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = s.length(); i < len; ++i) {
            sb.append("0");
        }
        sb.append(s);
        return sb.toString();
    }

    private static String formatErrBase(Throwable err) {
        if (err.getMessage() != null && !err.getMessage().isBlank()) {
            StringBuilder sb = new StringBuilder();
            if (!hideClassNameExceptions.contains(err.getClass())) {
                sb.append(err.getClass().getSimpleName()).append(": ");
            }
            sb.append(err.getMessage().trim());
            return sb.toString();
        }
        return err.toString();
    }

    public static String formatErr(Throwable err) {
        String base = Utils.formatErrBase(err);
        if (err instanceof RuntimeException || Logger.stackTraceOn) {
            return base + Arrays.asList(err.getStackTrace());
        }
        return base;
    }

    public static <T> String formatArrayToStringCompact(T[] arr) {
        if (arr.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (T s : arr) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static int zeros(byte b) {
        if ((b & 1) == 1) {
            return 0;
        }
        if ((b & 2) == 2) {
            return 1;
        }
        if ((b & 4) == 4) {
            return 2;
        }
        if ((b & 8) == 8) {
            return 3;
        }
        if ((b & 0x10) == 16) {
            return 4;
        }
        if ((b & 0x20) == 32) {
            return 5;
        }
        if ((b & 0x40) == 64) {
            return 6;
        }
        if ((b & 0x80) == 128) {
            return 7;
        }
        return 8;
    }

    public static byte[] long2bytes(long v) {
        LinkedList<Byte> bytes = new LinkedList<Byte>();
        while (v != 0L) {
            byte b = (byte)(v & 0xFFL);
            bytes.addFirst(b);
            v >>= 8;
        }
        byte[] ret = Utils.allocateByteArray(bytes.size());
        int idx = 0;
        Iterator iterator = bytes.iterator();
        while (iterator.hasNext()) {
            byte b;
            ret[idx] = b = ((Byte)iterator.next()).byteValue();
            ++idx;
        }
        return ret;
    }

    public static boolean lowBitsV6V4(byte[] ip, int lastLowIdx, int secondLastLowIdx) {
        for (int i = 0; i < secondLastLowIdx; ++i) {
            if (ip[i] == 0) continue;
            return false;
        }
        if (ip[lastLowIdx] == 0) {
            return ip[secondLastLowIdx] == 0;
        }
        if (ip[lastLowIdx] == -1) {
            return ip[secondLastLowIdx] == -1;
        }
        return false;
    }

    public static byte genPrefixByte(int ones) {
        switch (ones) {
            case 7: {
                return -2;
            }
            case 6: {
                return -4;
            }
            case 5: {
                return -8;
            }
            case 4: {
                return -16;
            }
            case 3: {
                return -32;
            }
            case 2: {
                return -64;
            }
            case 1: {
                return -128;
            }
        }
        if (ones >= 8) {
            return -1;
        }
        return 0;
    }

    public static String[] split(String str, String e) {
        LinkedList<String> ls = new LinkedList<String>();
        int idx = -e.length();
        int lastIdx = 0;
        while (true) {
            if ((idx = str.indexOf(e, idx + e.length())) == -1) break;
            ls.add(str.substring(lastIdx, idx));
            lastIdx = idx + e.length();
        }
        ls.add(str.substring(lastIdx));
        return ls.toArray(new String[ls.size()]);
    }

    public static long currentMinute() {
        return System.currentTimeMillis() / 60000L * 60000L;
    }

    public static void shiftLeft(byte[] arr, int l) {
        for (int i = 0; i < arr.length; ++i) {
            byte b;
            int e = i + l;
            arr[i] = b = e >= arr.length ? (byte)0 : arr[e];
        }
    }

    public static boolean isReset(IOException t) {
        return RESET_MSG.contains(t.getMessage());
    }

    public static boolean isBrokenPipe(IOException t) {
        return BROKEN_PIPE_MSG.equals(t.getMessage());
    }

    public static boolean isSSLEngineClosed(IOException t) {
        return SSL_ENGINE_CLOSED_MSG.equals(t.getMessage());
    }

    public static boolean isTerminatedIOException(IOException t) {
        return Utils.isReset(t) || Utils.isBrokenPipe(t) || Utils.isSSLEngineClosed(t);
    }

    public static boolean isHostIsDown(IOException t) {
        return HOST_IS_DOWN_MSG.equals(t.getMessage());
    }

    public static boolean isNoRouteToHost(IOException t) {
        return NO_ROUTE_TO_HOST_MSG.equals(t.getMessage());
    }

    public static String stackTrace() {
        StringWriter s = new StringWriter();
        new Throwable().printStackTrace(new PrintWriter(s));
        return s.toString();
    }

    public static int writeFromFIFOQueueToBufferPacketBound(Deque<ByteBuffer> bufs, ByteBuffer dst) {
        int ret = 0;
        while (!bufs.isEmpty()) {
            int dstPos;
            int bufPos;
            ByteBuffer b = bufs.peek();
            int bufLim = b.limit();
            if (bufLim - (bufPos = b.position()) == 0) {
                bufs.poll();
                continue;
            }
            int dstLim = dst.limit();
            if (dstLim - (dstPos = dst.position()) == 0 || dstLim - dstPos < bufLim - bufPos) break;
            ret += b.limit() - b.position();
            dst.put(b);
        }
        return ret;
    }

    public static int writeFromFIFOQueueToBuffer(Deque<ByteBuffer> bufs, ByteBuffer dst) {
        int ret = 0;
        while (!bufs.isEmpty()) {
            int dstPos;
            int oldPos;
            ByteBuffer b = bufs.peek();
            int oldLim = b.limit();
            if (oldLim - (oldPos = b.position()) == 0) {
                bufs.poll();
                continue;
            }
            int dstLim = dst.limit();
            if (dstLim - (dstPos = dst.position()) == 0) break;
            if (dstLim - dstPos < oldLim - oldPos) {
                b.limit(oldPos + (dstLim - dstPos));
            }
            ret += b.limit() - b.position();
            dst.put(b);
            b.limit(oldLim);
        }
        return ret;
    }

    public static byte[] binToBytes(String bin) {
        char[] chars = bin.toCharArray();
        if (chars.length % 8 != 0) {
            throw new IllegalArgumentException("invalid bin string");
        }
        byte[] ret = Utils.allocateByteArray(chars.length / 8);
        for (int i = 0; i < chars.length; i += 8) {
            int b = 0;
            for (int x = 0; x < 8; ++x) {
                char c = chars[i + x];
                if (c != '1' && c != '0') {
                    throw new IllegalArgumentException("char `" + c + "` cannot be bin");
                }
                int n = c == '1' ? 1 : 0;
                b |= n << 7 - x;
            }
            ret[i / 8] = (byte)b;
        }
        return ret;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexToBytes(String hex) {
        char[] chars = hex.toCharArray();
        if (chars.length % 2 != 0) {
            throw new IllegalArgumentException("invalid hex string");
        }
        byte[] ret = Utils.allocateByteArray(chars.length / 2);
        for (int i = 0; i < chars.length; i += 2) {
            byte b;
            char m = chars[i];
            char n = chars[i + 1];
            ret[i / 2] = b = (byte)(Utils.parseHexChar(m) << 4 | Utils.parseHexChar(n));
        }
        return ret;
    }

    private static byte parseHexChar(char c) {
        if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            throw new IllegalArgumentException("char `" + c + "' cannot be hex");
        }
        if ('0' <= c && c <= '9') {
            return (byte)(c - 48);
        }
        if ('a' <= c && c <= 'z') {
            return (byte)(c - 97 + 10);
        }
        return (byte)(c - 65 + 10);
    }

    public static boolean debug(Runnable r) {
        assert (((BooleanSupplier)() -> {
            r.run();
            return true;
        }).getAsBoolean());
        return true;
    }

    public static byte[] gzipCompress(ByteArrayOutputStream baos, byte[] plain) {
        try (GZIPOutputStream gzip = new GZIPOutputStream(baos){
            {
                this.def.setLevel(9);
            }
        };){
            gzip.write(plain);
        }
        catch (IOException e) {
            Logger.shouldNotHappen("running gzip compression failed", e);
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public static byte[] gzipDecompress(ByteArrayOutputStream baos, byte[] compressed) {
        ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
        try (GZIPInputStream gzip = new GZIPInputStream(bais);){
            int n;
            byte[] buf = Utils.allocateByteArray(1024);
            while ((n = gzip.read(buf, 0, buf.length)) >= 0) {
                baos.write(buf, 0, n);
            }
        }
        catch (IOException e) {
            Logger.shouldNotHappen("running gzip decompression failed", e);
            return null;
        }
        return baos.toByteArray();
    }

    public static boolean allZerosAfter(ByteArray bytes, int index) {
        for (int i = index; i < bytes.length(); ++i) {
            if (bytes.get(i) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean assertOn() {
        return assertOn;
    }

    public static byte[] allocateByteArray(int len) {
        if (len < 512) {
            return Utils.allocateByteArrayInitZero(len);
        }
        return JDKUnsafe.allocateUninitializedByteArray(len);
    }

    public static byte[] allocateByteArrayInitZero(int len) {
        return new byte[len];
    }

    public static byte[] getZeroLengthByteArray() {
        return ZERO_LENGTH_BYTE_ARRAY;
    }

    public static ByteBuffer allocateByteBuffer(int cap) {
        return ByteBuffer.wrap(Utils.allocateByteArray(cap));
    }

    public static <T> T runAvoidNull(Supplier<T> f, T dft) {
        try {
            return f.get();
        }
        catch (NullPointerException e) {
            return dft;
        }
    }

    public static String toHexString(int x) {
        String s = Integer.toHexString(x);
        if (s.length() % 2 == 0) {
            return "0x" + s;
        }
        return "0x0" + s;
    }

    public static String toHexStringWithPadding(int x, int bits) {
        assert (bits % 8 == 0);
        int len = bits / 4;
        Object s = Integer.toHexString(x);
        if (((String)s).length() < len) {
            s = "0".repeat(len - ((String)s).length()) + (String)s;
        }
        return "0x" + (String)s;
    }

    public static String toBinaryString(int x) {
        return "0b" + Integer.toBinaryString(x);
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isNonNegativeInteger(String s) {
        int n;
        try {
            n = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return n >= 0;
    }

    public static boolean isPositiveInteger(String s) {
        int n;
        try {
            n = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return n > 0;
    }

    public static boolean isLong(String s) {
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static void execute(String script) throws Exception {
        Utils.execute(script, false);
    }

    public static ExecuteResult execute(String script, boolean getResult) throws Exception {
        return Utils.execute(script, 10000, getResult);
    }

    public static void execute(String script, int timeout) throws Exception {
        Utils.execute(script, timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecuteResult execute(String script, int timeout, boolean getResult) throws Exception {
        if (script.contains("\n")) {
            Logger.alert("trying to execute script:\n" + script);
        } else {
            Logger.alert("trying to execute script: " + script);
        }
        File file = File.createTempFile("script", OS.isWindows() ? ".bat" : ".sh");
        try {
            Files.writeString(file.toPath(), (CharSequence)script, new OpenOption[0]);
            if (!file.setExecutable(true)) {
                throw new Exception("setting executable to script " + file.getAbsolutePath() + " failed");
            }
            ProcessBuilder pb = OS.isWindows() ? new ProcessBuilder("cmd.exe", "/c", file.getAbsolutePath()) : new ProcessBuilder(file.getAbsolutePath());
            ExecuteResult executeResult = Utils.execute(pb, timeout, getResult);
            return executeResult;
        }
        finally {
            file.delete();
        }
    }

    public static void execute(ProcessBuilder pb, int timeout) throws Exception {
        Utils.execute(pb, timeout, false);
    }

    public static ExecuteResult execute(ProcessBuilder pb, int timeout, boolean getResult) throws Exception {
        Process p = pb.start();
        BlockCallback<String, Exception> stdoutCB = new BlockCallback<String, Exception>();
        BlockCallback<String, Exception> stderrCB = new BlockCallback<String, Exception>();
        if (getResult) {
            Utils.readOutputOfSubProcess(p, stdoutCB, stderrCB);
        } else {
            Utils.pipeOutputOfSubProcess(p);
        }
        p.waitFor(timeout, TimeUnit.MILLISECONDS);
        if (p.isAlive()) {
            p.destroyForcibly();
            throw new Exception("the process took too long to execute");
        }
        int exit = p.exitValue();
        if (getResult) {
            return new ExecuteResult(exit, stdoutCB.block(), stderrCB.block());
        }
        if (exit == 0) {
            return null;
        }
        throw new Exception("exit code is " + exit);
    }

    public static void pipeOutputOfSubProcess(Process p) {
        InputStream stdout = p.getInputStream();
        InputStream stderr = p.getErrorStream();
        Utils.pipeOutputOfStream(stdout, "stdout");
        Utils.pipeOutputOfStream(stderr, "stderr");
    }

    private static void pipeOutputOfStream(InputStream stdout, String descr) {
        new Thread(() -> {
            BufferedReader br = new BufferedReader(new InputStreamReader(stdout));
            try {
                String x;
                while ((x = br.readLine()) != null) {
                    System.out.println(x);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                stdout.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, "pipe-output-of-stream-" + descr).start();
    }

    public static void readOutputOfSubProcess(Process p, Callback<String, Exception> stdoutCB, Callback<String, Exception> stderrCB) {
        InputStream stdout = p.getInputStream();
        InputStream stderr = p.getErrorStream();
        Utils.readOutputOfStream(stdout, "stdout", stdoutCB);
        Utils.readOutputOfStream(stderr, "stderr", stderrCB);
    }

    private static void readOutputOfStream(InputStream stdout, String descr, Callback<String, Exception> cb) {
        new Thread(() -> {
            StringBuilder sb = new StringBuilder();
            InputStreamReader reader = new InputStreamReader(stdout);
            char[] buf = new char[1024];
            try {
                int n;
                while ((n = reader.read(buf)) >= 0) {
                    if (n <= 0) continue;
                    sb.append(buf, 0, n);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                stdout.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            cb.succeeded(sb.toString());
        }, "read-output-of-stream-" + descr).start();
    }

    public static StackTraceElement[] stackTraceStartingFromThisMethodInclusive() {
        String meth = "stackTraceStartingFromThisMethodInclusive";
        StackTraceElement[] arr = Thread.currentThread().getStackTrace();
        int i = 0;
        for (StackTraceElement elem : arr) {
            ++i;
            if (elem.getMethodName().equals("stackTraceStartingFromThisMethodInclusive")) break;
        }
        StackTraceElement[] ret = new StackTraceElement[arr.length - i];
        System.arraycopy(arr, i, ret, 0, ret.length);
        return ret;
    }

    public static void exit(int code) {
        System.exit(code);
    }

    public static ByteArray buildPseudoIPv4Header(Ipv4Packet ipv4, int upperType, int upperLength) {
        ByteArray pseudoHeaderTail = ByteArray.allocate(4);
        ByteArray pseudoHeader = ByteArray.from(ipv4.getSrc().getAddress()).concat(ByteArray.from(ipv4.getDst().getAddress())).concat(pseudoHeaderTail);
        pseudoHeaderTail.set(1, (byte)upperType);
        pseudoHeaderTail.int16(2, upperLength);
        return pseudoHeader;
    }

    public static ByteArray buildPseudoIPv6Header(Ipv6Packet ipv6, int upperType, int upperLength) {
        ByteArray pseudoHeaderTail = ByteArray.allocate(8);
        ByteArray pseudoHeader = ByteArray.from(ipv6.getSrc().getAddress()).concat(ByteArray.from(ipv6.getDst().getAddress())).concat(pseudoHeaderTail);
        pseudoHeaderTail.int32(0, upperLength);
        pseudoHeaderTail.set(7, (byte)upperType);
        return pseudoHeader;
    }

    public static int calculateChecksum(ByteArray array, int limit) {
        int sum = 0;
        for (int i = 0; i < limit / 2; ++i) {
            sum += array.uint16(i * 2);
            while (sum > 65535) {
                sum = (sum & 0xFFFF) + 1;
            }
        }
        if (limit % 2 != 0) {
            sum += array.uint8(limit - 1) << 8;
            while (sum > 65535) {
                sum = (sum & 0xFFFF) + 1;
            }
        }
        return 65535 - sum;
    }

    public static byte[] sha1(byte[] input) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            Logger.shouldNotHappen("SHA-1 not found");
            throw new RuntimeException(e);
        }
        md.update(input);
        return md.digest();
    }

    public static String getSystemProperty(String key) {
        return Utils.getSystemProperty(key, null);
    }

    public static String getSystemProperty(String pattern, String defaultValue) {
        String[] split = pattern.split("_");
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        String ret = System.getProperty("io.vproxy." + Utils.namingConventionPascal(split));
        if (ret != null) {
            results.add(ret);
        }
        if ((ret = System.getProperty("vproxy." + Utils.namingConventionPascal(split))) != null) {
            results.add(ret);
        }
        if ((ret = System.getProperty("vproxy_" + Utils.namingConventionUnderline(split, false))) != null) {
            results.add(ret);
        }
        if ((ret = System.getProperty("VPROXY_" + Utils.namingConventionUnderline(split, true))) != null) {
            results.add(ret);
        }
        if ((ret = System.getenv("VPROXY_" + Utils.namingConventionUnderline(split, true))) != null) {
            results.add(ret);
        }
        if ((ret = Utils.exactlyOneProperty(results)) != null) {
            return ret;
        }
        results.clear();
        if (split[0].startsWith("d") && (ret = System.getProperty(Utils.namingConventionPascal(split).substring(1))) != null) {
            results.add(ret);
        }
        if ((ret = System.getProperty(Utils.namingConventionPascal(split))) != null) {
            results.add(ret);
        }
        if ((ret = System.getProperty(Utils.namingConventionCamel(split))) != null) {
            results.add(ret);
        }
        if ((ret = System.getProperty(Utils.namingConventionUnderline(split, false))) != null) {
            results.add(ret);
        }
        if ((ret = System.getProperty(Utils.namingConventionUnderline(split, true))) != null) {
            results.add(ret);
        }
        if ((ret = System.getProperty(Utils.namingConventionJoin(split, false))) != null) {
            results.add(ret);
        }
        if ((ret = System.getProperty(Utils.namingConventionJoin(split, true))) != null) {
            results.add(ret);
        }
        if ((ret = Utils.exactlyOneProperty(results)) != null) {
            return ret;
        }
        return defaultValue;
    }

    private static String exactlyOneProperty(Set<String> results) {
        if (results.isEmpty()) {
            return null;
        }
        String res = results.iterator().next();
        if (results.size() > 1) {
            Logger.warn(LogType.ALERT, "multiple values of keys in different patterns set for the same property: " + results + ", using: " + res);
        }
        return res;
    }

    private static String namingConventionPascal(String[] split) {
        StringBuilder sb = new StringBuilder();
        sb.append(split[0].substring(0, 1).toUpperCase());
        sb.append(split[0].substring(1));
        for (int i = 1; i < split.length; ++i) {
            sb.append(split[i].substring(0, 1).toUpperCase());
            sb.append(split[i].substring(1));
        }
        return sb.toString();
    }

    private static String namingConventionCamel(String[] split) {
        StringBuilder sb = new StringBuilder();
        sb.append(split[0]);
        for (int i = 1; i < split.length; ++i) {
            sb.append(split[i].substring(0, 1).toUpperCase());
            sb.append(split[i].substring(1));
        }
        return sb.toString();
    }

    private static String namingConventionUnderline(String[] split, boolean upper) {
        if (upper) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < split.length; ++i) {
                if (i != 0) {
                    sb.append("_");
                }
                sb.append(split[i].toUpperCase());
            }
            return sb.toString();
        }
        return String.join((CharSequence)"_", split);
    }

    private static String namingConventionJoin(String[] split, boolean upper) {
        if (upper) {
            StringBuilder sb = new StringBuilder();
            for (String s : split) {
                sb.append(s.toUpperCase());
            }
            return sb.toString();
        }
        return String.join((CharSequence)"", split);
    }

    public static List<Nic> getNetworkInterfaces() throws IOException {
        ArrayList<Nic> ret = new ArrayList<Nic>();
        if (!OS.isLinux()) {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                ret.add(new Nic(iface.getName(), new MacAddress(iface.getHardwareAddress()), -1, iface.isVirtual()));
            }
            return ret;
        }
        String[] lines = Files.readString(Path.of("/proc/net/dev", new String[0])).split("\n");
        for (int i = 2; i < lines.length; ++i) {
            MacAddress mac;
            int idx;
            String line = lines[i];
            if (line.isBlank() || (idx = (line = line.trim()).indexOf(":")) == -1) continue;
            String name = line.substring(0, idx);
            File virtualPath = new File("/sys/devices/virtual/net/" + name + "/");
            boolean isVirtual = virtualPath.exists();
            String macStr = Files.readString(Path.of("/sys/class/net/" + name + "/address", new String[0])).trim();
            try {
                mac = new MacAddress(macStr);
            }
            catch (IllegalArgumentException e) {
                if (isVirtual) {
                    mac = new MacAddress("00:00:00:00:00:00");
                }
                throw new IOException("unable to parse mac for " + name + ": " + macStr, e);
            }
            int speed = -1;
            try {
                String speedStr = Files.readString(Path.of("/sys/class/net/" + name + "/speed", new String[0])).trim();
                speed = Integer.parseInt(speedStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ret.add(new Nic(name, mac, speed, isVirtual));
        }
        return ret;
    }

    public static void loadDynamicLibrary(String name) throws UnsatisfiedLinkError {
        Utils.loadDynamicLibrary(name, Utils.class.getClassLoader(), "io/vproxy/");
    }

    public static void loadDynamicLibrary(String name, ClassLoader cl, String basePath) throws UnsatisfiedLinkError {
        File f;
        String suffix;
        if (((String)basePath).startsWith("/")) {
            basePath = ((String)basePath).substring(1);
        }
        if (!((String)basePath).endsWith("/")) {
            basePath = (String)basePath + "/";
        }
        String filename = "lib" + name + "-" + OS.arch();
        if (OS.isMac()) {
            suffix = ".dylib";
        } else if (OS.isWindows()) {
            filename = name + "-" + OS.arch();
            suffix = ".dll";
        } else {
            suffix = ".so";
        }
        String pathInClasspath = (String)basePath + filename + suffix;
        System.out.print("checking classpath " + pathInClasspath + " for dynamic library: ");
        InputStream is = cl.getResourceAsStream(pathInClasspath);
        if (is == null) {
            System.out.println("missing.");
            System.out.println("System.loadLibrary(" + name + ")");
            System.loadLibrary(name);
            return;
        }
        System.out.println("found.");
        try {
            f = File.createTempFile(filename + "-", suffix);
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError(Utils.formatErr(e));
        }
        f.deleteOnExit();
        try (InputStream e = is;){
            byte[] buf = new byte[1024];
            try (FileOutputStream fos = new FileOutputStream(f);){
                int n;
                while ((n = is.read(buf)) > 0) {
                    fos.write(buf, 0, n);
                }
                fos.flush();
            }
        }
        catch (IOException e2) {
            throw new UnsatisfiedLinkError(Utils.formatErr(e2));
        }
        if (!f.setExecutable(true)) {
            throw new UnsatisfiedLinkError("failed setting executable on tmp file " + f.getAbsolutePath());
        }
        System.out.println("System.load(" + f.getAbsolutePath() + ")");
        System.load(f.getAbsolutePath());
        f.delete();
    }

    public static void validateVProxyVersion(String version) throws Exception {
        String majorMinorPatch = version;
        if (version.contains("-")) {
            if (version.startsWith("-")) {
                throw new Exception("invalid version, must not start with `-`: " + version);
            }
            if (version.endsWith("-")) {
                throw new Exception("invalid version, must not end with `-`: " + version);
            }
            String[] splitBySlash = version.split("-");
            if (splitBySlash.length != 3 && splitBySlash.length != 4) {
                throw new Exception("invalid version, invalid slash count: " + version);
            }
            String versionCat = splitBySlash[1];
            if (!(versionCat.equals("ALPHA") || versionCat.equals("BETA") || versionCat.equals("RC"))) {
                throw new Exception("invalid version, expecting ALPHA|BETA|RC, but got: " + versionCat);
            }
            String unstableNumberStr = splitBySlash[2];
            if (!Utils.isPositiveInteger(unstableNumberStr)) {
                throw new Exception("invalid version, expecting unstable version to be positive integer, but got: " + unstableNumberStr);
            }
            if (splitBySlash.length == 4 && !splitBySlash[3].equals("DEV")) {
                throw new Exception("invalid version, expecting DEV tag, but got: " + splitBySlash[3]);
            }
            majorMinorPatch = splitBySlash[0];
        }
        if (majorMinorPatch.startsWith(".")) {
            throw new Exception("invalid version, major.minor.patch must not start with `.`: " + majorMinorPatch);
        }
        if (majorMinorPatch.endsWith(".")) {
            throw new Exception("invalid version, major.minor.patch must not end with `.`: " + majorMinorPatch);
        }
        String[] split = majorMinorPatch.split("\\.");
        if (split.length != 3) {
            throw new Exception("invalid version, not major.minor.patch: " + majorMinorPatch);
        }
        String major = split[0];
        if (!Utils.isNonNegativeInteger(major)) {
            throw new Exception("invalid version, major version is not non-negative integer: " + major);
        }
        String minor = split[1];
        if (!Utils.isNonNegativeInteger(minor)) {
            throw new Exception("invalid version, minor version is not non-negative integer: " + minor);
        }
        String patch = split[2];
        if (!Utils.isNonNegativeInteger(patch)) {
            throw new Exception("invalid version, patch version is not non-negative integer: " + patch);
        }
    }

    public static int compareVProxyVersions(String a, String b) {
        int unstableB;
        int[] mmpBN;
        if (a.equals(b)) {
            return 0;
        }
        String[] mmpA = (a.contains("-") ? a.split("-")[0] : a).split("\\.");
        String[] mmpB = (b.contains("-") ? b.split("-")[0] : b).split("\\.");
        int[] mmpAN = new int[]{Integer.parseInt(mmpA[0]), Integer.parseInt(mmpA[1]), Integer.parseInt(mmpA[2])};
        if (mmpAN[0] > (mmpBN = new int[]{Integer.parseInt(mmpB[0]), Integer.parseInt(mmpB[1]), Integer.parseInt(mmpB[2])})[0]) {
            return 1;
        }
        if (mmpAN[0] < mmpBN[0]) {
            return -1;
        }
        if (mmpAN[1] > mmpBN[1]) {
            return 1;
        }
        if (mmpAN[1] < mmpBN[1]) {
            return -1;
        }
        if (mmpAN[2] > mmpBN[2]) {
            return 1;
        }
        if (mmpAN[2] < mmpBN[2]) {
            return -1;
        }
        if (a.contains("-") && !b.contains("-")) {
            return -1;
        }
        if (b.contains("-") && !a.contains("-")) {
            return 1;
        }
        String[] splitA = a.split("-");
        String[] splitB = b.split("-");
        String catA = splitA[1];
        String catB = splitB[1];
        if (catA.equals("ALPHA") && !catB.equals("ALPHA")) {
            return -1;
        }
        if (catB.equals("ALPHA") && !catA.equals("ALPHA")) {
            return 1;
        }
        if (catA.equals("BETA") && catB.equals("RC")) {
            return -1;
        }
        if (catB.equals("BETA") && catA.equals("RC")) {
            return 1;
        }
        if (catA.equals("RC") && !catB.equals("RC")) {
            return 1;
        }
        if (catB.equals("RC") && !catA.equals("RC")) {
            return -1;
        }
        int unstableA = Integer.parseInt(splitA[2]);
        if (unstableA > (unstableB = Integer.parseInt(splitB[2]))) {
            return 1;
        }
        if (unstableB > unstableA) {
            return -1;
        }
        if (splitA.length == 3 && splitB.length == 4) {
            return 1;
        }
        if (splitB.length == 3 && splitA.length == 4) {
            return -1;
        }
        throw new Error("should not reach here: " + a + " <==> " + b);
    }

    public static int maskNumberToInt(int maskNumber) {
        if (maskNumber > 32) {
            throw new IllegalArgumentException("mask for ipv4 should be between [0,32], but got " + maskNumber);
        }
        if (maskNumber < 0) {
            throw new IllegalArgumentException("mask for ipv4 should be between [0,32], but got " + maskNumber);
        }
        return maskValues[maskNumber];
    }

    public static String formatTimestampForFileName(long ts) {
        Date d = new Date(ts);
        return d.getYear() + 1900 + "-" + Utils.fillToTen(d.getMonth() + 1) + "-" + Utils.fillToTen(d.getDate()) + "_" + Utils.fillToTen(d.getHours()) + "-" + Utils.fillToTen(d.getMinutes()) + "-" + Utils.fillToTen(d.getSeconds());
    }

    public static String formatTimestampForLogging(long ts) {
        Date d = new Date(ts);
        return d.getYear() + 1900 + "-" + Utils.fillToTen(d.getMonth() + 1) + "-" + Utils.fillToTen(d.getDate()) + " " + Utils.fillToTen(d.getHours()) + ":" + Utils.fillToTen(d.getMinutes()) + ":" + Utils.fillToTen(d.getSeconds()) + "." + Utils.fillToHundred((int)(ts % 1000L));
    }

    private static String fillToTen(int n) {
        return (n < 10 ? "0" : "") + n;
    }

    private static String fillToHundred(int n) {
        return (n < 10 ? "00" : (n < 100 ? "0" : "")) + n;
    }

    public static String escapePath(File path) {
        return Utils.escapePath(path.getAbsolutePath());
    }

    public static String escapePath(Path path) {
        return Utils.escapePath(path.toAbsolutePath().toString());
    }

    public static String escapePath(String path) {
        if (OS.isWindows()) {
            return "\"" + path + "\"";
        }
        char escape = '\\';
        char[] chars = path.toCharArray();
        StringBuilder sb = new StringBuilder("\"");
        for (char c : chars) {
            if (c == '\"') {
                sb.append(escape);
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }

    static {
        boolean _assertOn;
        RESET_MSG = Arrays.asList("Connection reset by peer", "Connection reset");
        sync = 0;
        try {
            assert (false);
            _assertOn = false;
        }
        catch (AssertionError ignore) {
            _assertOn = true;
        }
        assertOn = _assertOn;
        hideClassNameExceptions = Set.of(Exception.class, XException.class, RuntimeException.class, Error.class, Throwable.class, AlreadyExistException.class, NotFoundException.class);
        HEX_ARRAY = "0123456789abcdef".toCharArray();
        ZERO_LENGTH_BYTE_ARRAY = new byte[0];
        maskValues = new int[33];
        for (int i = 1; i <= 32; ++i) {
            int res = 0;
            for (int j = 1; j <= i; ++j) {
                res = 1 << 32 - j | res;
            }
            Utils.maskValues[i] = res;
        }
    }

    public static class ExecuteResult {
        public final int exitCode;
        public final String stdout;
        public final String stderr;

        public ExecuteResult(int exitCode, String stdout, String stderr) {
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        public String toString() {
            return "ExecuteResult{exitCode=" + this.exitCode + "\n----- stdout -----\n" + this.stdout + "\n----- stderr -----\n" + this.stderr + "\n}";
        }
    }

    public static interface UtilSupplier<T> {
        public T get() throws Exception;
    }
}

